#! /bin/sh
# Compile and install skript for the plus package for Solaris 10 (Sparc and x86)
#
# Execute this batch file in the .../agena/src folder by typing:
# sh makeplussolaris.sh
#
# Note that libgcc_s.so and libgcc_s.so.1 must exist in /usr/lib and
# /usr/local/lib so that the modules can be used.

# delete *.o files not deleted by make clean
for i in ads.o calc.o linalg.o stats.o fractals.o phq.o xbase.o net.o bags.o astro.o moon.o sunriset.o skycrane.o llist.o
do
   if [ -f i ]; then
      rm i
   fi
done

OPTIONS="-O3 -fpic"

printf "Compiling ADS ... "
gcc $OPTIONS -c -o ads.o ads.c
gcc -O -shared -fpic -o ads.so ads.o
printf "done.\n"

if [ -f ../phq/phq.c ]; then
   printf "Compiling phonetiQs ... "
   gcc $OPTIONS -c -o phq.o ../phq/phq.c
   gcc -O -shared -fpic -o phq.so phq.o
   printf "done.\n"
   strip phq.so
   mv phq.so ../phq
fi

printf "Compiling calc ... "
gcc $OPTIONS -c -o calc.o calc.c
gcc $OPTIONS -c -o interp.o interp.c
gcc -O -shared -fpic -o calc.so calc.o interp.o
printf "done.\n"

printf "Compiling stats ... "
gcc $OPTIONS -c -o stats.o stats.c
gcc -O -shared -fpic -o stats.so stats.o
printf "done.\n"

printf "Compiling linalg ... "
gcc $OPTIONS -c -o linalg.o linalg.c
gcc -O -shared -fpic -o linalg.so linalg.o
printf "done.\n"

printf "Compiling fractals ... "
gcc $OPTIONS -c -o fractals.o fractals.c
gcc -O -shared -fpic -o fractals.so fractals.o
printf "done.\n"

printf "Compiling xbase ... "
gcc $OPTIONS -c -o xbase.o xbase.c
gcc -O -shared -fpic -o xbase.so xbase.o
printf "done.\n"

printf "Compiling net ... "
gcc $OPTIONS -c -o net.o net.c
gcc -O -shared -fpic -o net.so net.o -lsocket -lnsl
printf "done.\n"

printf "Compiling bags ... "
gcc $OPTIONS -c -o bags.o bags.c
gcc -O -shared -fpic -o bags.so bags.o
printf "done.\n"

printf "Compiling llist ... "
gcc $OPTIONS -c -o llist.o llist.c
gcc -O -shared -fpic -o llist.so llist.o
printf "done.\n"

printf "Compiling astro ... "
gcc $OPTIONS -c -o astro.o astro.c
gcc $OPTIONS -c -o moon.o moon.c
gcc $OPTIONS -c -o sunriset.o sunriset.c
gcc -O -shared -fpic -o astro.so astro.o sunriset.o moon.o
printf "done.\n"

printf "Compiling skycrane ... "
gcc $OPTIONS -c -o skycrane.o skycrane.c
gcc -O -shared -fpic -o skycrane.so skycrane.o
printf "done.\n"

printf "Slimming and moving packages ... "
strip *.so
mv ads.so ../lib
mv calc.so ../lib
mv stats.so ../lib
mv linalg.so ../lib
mv fractals.so ../lib
mv xbase.so ../lib
mv net.so ../lib
mv bags.so ../lib
mv llist.so ../lib
mv astro.so ../lib
mv skycrane.so ../lib

printf "done.\n"

echo Installed all libraries into /lib folder.
echo All done.

