#! /bin/sh
# compile and install skript for the plus package on Mac OS X 10.4 or later
# execute this batch file in the .../agena/src folder by typing:
# sh makeplusmacosx.sh
# linking and stripping do not work here

export OPTIONS1="-O2 -fno-common -c -force_cpusubtype_ALL -mmacosx-version-min=10.4 -arch ppc -arch ppc64 "
export OPTIONS2="-bundle -undefined dynamic_lookup -mmacosx-version-min=10.4 -arch ppc -arch ppc64"

export EXPORTTO="../lib"

# delete *.o files not deleted by make clean
for i in ads.o calc.o linalg.o stats.o fractals.o phq.o
do
   if [ -f i ]; then
      rm i
   fi
done

printf "Compiling ADS ... "
gcc $OPTIONS1 -o ads.o ads.c
gcc $OPTIONS2 -o ads.so ads.o
mv -f ads.so $EXPORTTO
printf "done.\n"

printf "Compiling phonetiQs ... "
gcc $OPTIONS1 -o phq.o ../phq/phq.c
gcc $OPTIONS2 -o phq.so phq.o
mv -f phq.so ../phq
printf "done.\n"

# do not use -O switch because this will lead to roundoffs in calc.fseq
printf "Compiling calc ... "
gcc $OPTIONS1 -o calc.o calc.c
gcc $OPTIONS2 -o calc.so calc.o
mv -f calc.so $EXPORTTO
printf "done.\n"

printf "Compiling stats ... "
gcc $OPTIONS1 -o stats.o stats.c
gcc $OPTIONS2 -o stats.so stats.o
mv -f stats.so $EXPORTTO
printf "done.\n"

printf "Compiling linalg ... "
gcc $OPTIONS1 -o linalg.o linalg.c
gcc $OPTIONS2 -o linalg.so linalg.o
mv -f linalg.so $EXPORTTO
printf "done.\n"

printf "Compiling fractals ... "
gcc $OPTIONS1 -o fractals.o fractals.c
gcc $OPTIONS2 -o fractals.so fractals.o
mv -f fractals.so $EXPORTTO
printf "done.\n"

printf "Compiling xbase ... "
gcc $OPTIONS1 -o xbase.o xbase.c
gcc $OPTIONS2 -o xbase.so xbase.o
mv -f xbase.so $EXPORTTO
printf "done.\n"

#printf "Compiling compress ... "
#gcc $OPTIONS -o compress.so compress.c lcompress.c ../src/agnhlps.c
#mv -f compress.so $EXPORTTO
#printf "done.\n"

echo Installing all libraries into /lib folder ...
echo All done.

