#! /bin/sh
# compile-and-install skript for the plus package on Mac OS X 10.4 or later
# execute this batch file in the .../agena/src folder by typing:
# sh makeplusmacosx.sh
# linking and stripping do not work here

export OPTIONS1="-O2 -fno-common -c -force_cpusubtype_ALL -mmacosx-version-min=10.4"
export OPTIONS2="-bundle -undefined dynamic_lookup -force_cpusubtype_ALL -mmacosx-version-min=10.4"

#export OPTIONS1="-O2 -fno-common -c -force_cpusubtype_ALL -mmacosx-version-min=10.4 -arch i386 -arch ppc -arch ppc64"
#export OPTIONS2="-bundle -undefined dynamic_lookup -force_cpusubtype_ALL -mmacosx-version-min=10.4 -arch i386 -arch ppc  -arch ppc64"

export EXPORTTO="../lib"

# delete *.o files not deleted by make clean
for i in ads.o calc.o linalg.o stats.o fractals.o phq.o net.o xbase.o interp.o moon.o sunriset.o astro.o skycrane.o llist.o
do
   if [ -f i ]; then
      rm i
   fi
done

printf "Compiling ADS ... "
gcc $OPTIONS1 -o ads.o ads.c
gcc $OPTIONS2 -o ads.so ads.o
mv -f ads.so $EXPORTTO
printf "done.\n"

if [ -f ../phq/phq.c ]; then
   printf "Compiling phonetiQs ... "
   gcc $OPTIONS1 -o phq.o ../phq/phq.c
   gcc $OPTIONS2 -o phq.so phq.o
   mv -f phq.so ../phq
   printf "done.\n"
fi

# do not use -O switch because this will lead to roundoffs in calc.fseq
printf "Compiling calc ... "
gcc $OPTIONS1 -o calc.o calc.c
gcc $OPTIONS1 -o interp.o interp.c
gcc $OPTIONS2 -o calc.so calc.o interp.o
mv -f calc.so $EXPORTTO
printf "done.\n"

printf "Compiling stats ... "
gcc $OPTIONS1 -o stats.o stats.c
gcc $OPTIONS2 -o stats.so stats.o
mv -f stats.so $EXPORTTO
printf "done.\n"

printf "Compiling linalg ... "
gcc $OPTIONS1 -o linalg.o linalg.c
gcc $OPTIONS2 -o linalg.so linalg.o
mv -f linalg.so $EXPORTTO
printf "done.\n"

printf "Compiling fractals ... "
gcc $OPTIONS1 -o fractals.o fractals.c
gcc $OPTIONS2 -o fractals.so fractals.o
mv -f fractals.so $EXPORTTO
printf "done.\n"

printf "Compiling xbase ... "
gcc $OPTIONS1 -o xbase.o xbase.c
gcc $OPTIONS2 -o xbase.so xbase.o
mv -f xbase.so $EXPORTTO
printf "done.\n"

printf "Compiling net ... "
gcc $OPTIONS1 -o net.o net.c
gcc $OPTIONS2 -o net.so net.o
mv -f net.so $EXPORTTO
printf "done.\n"

printf "Compiling bags ... "
gcc $OPTIONS1 -o bags.o bags.c
gcc $OPTIONS2 -o bags.so bags.o
mv -f bags.so $EXPORTTO
printf "done.\n"

#printf "Compiling compress ... "
#gcc $OPTIONS -o compress.so compress.c lcompress.c ../src/agnhlps.c
#mv -f compress.so $EXPORTTO
#printf "done.\n"

printf "Compiling astro ... "
gcc $OPTIONS1 -o moon.o moon.c
gcc $OPTIONS1 -o sunriset.o sunriset.c
gcc $OPTIONS1 -o astro.o astro.c
gcc $OPTIONS2 -o astro.so astro.o moon.o sunriset.o
mv -f astro.so $EXPORTTO
printf "done.\n"

printf "Compiling skycrane ... "
gcc $OPTIONS1 -o skycrane.o skycrane.c
gcc $OPTIONS2 -o skycrane.so skycrane.o
mv -f skycrane.so $EXPORTTO
printf "done.\n"

printf "Compiling llist ... "
gcc $OPTIONS1 -o llist.o llist.c
gcc $OPTIONS2 -o llist.so llist.o
mv -f llist.so $EXPORTTO
printf "done.\n"

echo Installing all libraries into /lib folder ...
echo All done.

