#! /bin/sh
# compile and install skript for the plus package for Linux
# execute this batch file in the .../agena/src folder by typing:
# sh makepluslinux.sh
export OPTIONS="-DLUA_USE_LINUX -Wall -O2 -shared -I../src -L../src ../src/libagena.a"
export EXPORTTO="../lib"

# delete *.o files not deleted by make clean
for i in ads.o calc.o linalg.o stats.o fractals.o phq.o xbase.o net.o interp.o moon.o sunriset.o astro.o skycrane.o llist.o bags.o
do
   if [ -f i ]; then
      rm i
   fi
done

printf "Compiling ADS ... "
gcc $OPTIONS -o ads.so ads.c
strip ads.so
mv -f ads.so $EXPORTTO
printf "done.\n"

if [ -f ../phq/phq.c ]; then
   printf "Compiling phonetiQs ... "
   gcc $OPTIONS -o phq.so ../phq/phq.c
   strip phq.so
   mv -f phq.so ../phq
   printf "done.\n"
fi

# do not use -O switch because this will lead to roundoffs in calc.fseq
printf "Compiling calc ... "
gcc -O2 -fpic -c -o calc.o calc.c
gcc -O2 -fpic -c -o interp.o interp.c
#gcc -O2 -shared -fpic -o calc.so calc.o interp.o cephes.o -L. -lagena
gcc $OPTIONS -fpic -o calc.so calc.o interp.o cephes.o

strip calc.so
mv -f calc.so $EXPORTTO
printf "done.\n"

printf "Compiling stats ... "
gcc $OPTIONS -o stats.so stats.c
strip stats.so
mv -f stats.so $EXPORTTO
printf "done.\n"

printf "Compiling linalg ... "
gcc $OPTIONS -o linalg.so linalg.c
strip linalg.so
mv -f linalg.so $EXPORTTO
printf "done.\n"

printf "Compiling fractals ... "
gcc $OPTIONS -o fractals.so fractals.c
strip fractals.so
mv -f fractals.so $EXPORTTO
printf "done.\n"

printf "Compiling xbase ... "
gcc $OPTIONS -o xbase.so xbase.c
strip xbase.so
mv -f xbase.so $EXPORTTO
printf "done.\n"

printf "Compiling net ... "
gcc $OPTIONS -o net.so net.c
strip net.so
mv -f net.so $EXPORTTO
printf "done.\n"

printf "Compiling bags ... "
gcc $OPTIONS -o bags.so bags.c
strip bags.so
mv -f bags.so $EXPORTTO
printf "done.\n"

printf "Compiling astro ... "
gcc -O2 -fpic -c -o astro.o astro.c
gcc -O2 -fpic -c -o sunriset.o sunriset.c
gcc -O2 -fpic -c -o moon.o moon.c
#gcc -O2 -shared -fpic -o astro.so astro.o sunriset.o moon.o sofa.o -L. -lagena
gcc $OPTIONS -fpic -o astro.so astro.o sunriset.o moon.o sofa.o

strip astro.so
mv -f astro.so $EXPORTTO
printf "done.\n"

printf "Compiling skycrane ... "
gcc $OPTIONS -o skycrane.so skycrane.c
strip skycrane.so
mv -f skycrane.so $EXPORTTO
printf "done.\n"

printf "Compiling llist ... "
gcc $OPTIONS -o llist.so llist.c
strip llist.so
mv -f llist.so $EXPORTTO
printf "done.\n"

#printf "Compiling compress ... "
#gcc $OPTIONS -o compress.so compress.c lcompress.c ../src/agnhlps.c
#strip compress.so
#mv -f compress.so $EXPORTTO
#printf "done.\n"

echo Installing all libraries into /lib folder ...
echo All done.


