#! /bin/sh
# compile and install skript for the plus package for Linux
# execute this batch file in the .../agena/src folder by typing:
# sh makepluslinux.sh
export CC="/boot/develop/abi/x86/gcc4/tools/gcc-4.3.3-haiku-100425/bin/gcc"
export OPTIONS="-DLUA_USE_LINUX -Wall -O2 -shared -DPROPCMPLX -I../src -L../src ../src/libagena.a"
export EXPORTTO="../lib"

# delete *.o files not deleted by make clean
for i in ads.o calc.o linalg.o stats.o fractals.o phq.o xbase.o net.o
do
   if [ -f i ]; then
      rm i
   fi
done

printf "Compiling ADS ... "
$CC $OPTIONS -o ads.so ads.c
strip ads.so
mv -f ads.so $EXPORTTO
printf "done.\n"

printf "Compiling phonetiQs ... "
$CC $OPTIONS -o phq.so ../phq/phq.c
strip phq.so
mv -f phq.so ../phq
printf "done.\n"

# do not use -O switch because this will lead to roundoffs in calc.fseq
printf "Compiling calc ... "
$CC $OPTIONS -o calc.so calc.c
strip calc.so
mv -f calc.so $EXPORTTO
printf "done.\n"

printf "Compiling stats ... "
$CC $OPTIONS -o stats.so stats.c
strip stats.so
mv -f stats.so $EXPORTTO
printf "done.\n"

printf "Compiling linalg ... "
$CC $OPTIONS -o linalg.so linalg.c
strip linalg.so
mv -f linalg.so $EXPORTTO
printf "done.\n"

printf "Compiling fractals ... "
$CC $OPTIONS -o fractals.so fractals.c
strip fractals.so
mv -f fractals.so $EXPORTTO
printf "done.\n"

printf "Compiling xbase ... "
$CC $OPTIONS -o xbase.so xbase.c
strip xbase.so
mv -f xbase.so $EXPORTTO
printf "done.\n"

printf "Compiling net ... "
$CC $OPTIONS -o net.so net.c
strip net.so
mv -f net.so $EXPORTTO
printf "done.\n"

#printf "Compiling compress ... "
#gcc $OPTIONS -o compress.so compress.c lcompress.c ../src/agnhlps.c
#strip compress.so
#mv -f compress.so $EXPORTTO
#printf "done.\n"

echo Installing all libraries into /lib folder ...
echo All done.

