/*
** $Id: lvm.h,v 2.5 2005/08/22 18:54:49 roberto Exp $
** Lua virtual machine
** See Copyright Notice in agena.h
*/

#ifndef lvm_h
#define lvm_h


#include "ldo.h"
#include "lobject.h"
#include "ltm.h"


#define tostring(L,o) ((ttype(o) == LUA_TSTRING) || (luaV_tostring(L, o)))

#define tonumber(o,n)	(ttype(o) == LUA_TNUMBER || \
                         (((o) = luaV_tonumber(o,n)) != NULL))

/* 0.26.1 */
#define tocomplex(o,n)	(ttype(o) == LUA_TCOMPLEX || \
                         (((o) = luaV_tocomplex(o,n)) != NULL))

#define equalobj(L,o1,o2) \
	(ttype(o1) == ttype(o2) ? luaV_equalval(L, o1, o2) : \
	   (ttype(o1) == LUA_TCOMPLEX || ttype(o2) == LUA_TCOMPLEX ? luaV_equalncomplex(L,o1,o2) : 0 ) )

#define equalobjonebyone(L,o1,o2) \
	(ttype(o1) == ttype(o2) ? luaV_equalvalonebyone(L, o1, o2) : \
	   (ttype(o1) == LUA_TCOMPLEX || ttype(o2) == LUA_TCOMPLEX ? luaV_equalncomplex(L,o1,o2) : 0 ) )


LUAI_FUNC int luaV_lessthan (lua_State *L, const TValue *l, const TValue *r);
LUAI_FUNC int luaV_equalval (lua_State *L, const TValue *t1, const TValue *t2);
LUAI_FUNC int luaV_equalncomplex (lua_State *L, const TValue *t1, const TValue *t2);
LUAI_FUNC const TValue *luaV_tonumber (const TValue *obj, TValue *n);
LUAI_FUNC const TValue *luaV_arithmoperand (const TValue *obj, TValue *n);  /* 0.28.2 */
LUAI_FUNC const TValue *luaV_tocomplex (const TValue *obj, TValue *n);  /* 0.26.1 */
LUAI_FUNC int luaV_tostring (lua_State *L, StkId obj);
LUAI_FUNC void luaV_gettable (lua_State *L, const TValue *t, TValue *key,
                                            StkId val);
LUAI_FUNC void luaV_settable (lua_State *L, const TValue *t, TValue *key,
                                            StkId val);
LUAI_FUNC void luaV_execute (lua_State *L, int nexeccalls);
LUAI_FUNC void luaV_concat (lua_State *L, int total, int last);

LUAI_FUNC size_t agenaV_nops (lua_State *L, Table *t);  /* 0.9.1 */
LUAI_FUNC int agenaV_comptablesonebyone (lua_State *L, Table *t1, Table *t2);  /* 0.22.0 */
LUAI_FUNC void agenaV_copy (lua_State *L, const TValue *tbl, StkId idx, Table *seen);  /* 0.22.1 */
LUAI_FUNC int luaV_equalvalonebyone (lua_State *L, const TValue *t1, const TValue *t2);

#endif

