/*
** $Id: ltm.h,v 2.6 2005/06/06 13:30:25 roberto Exp $
** Tag methods
** See Copyright Notice in agena.h
*/

#ifndef ltm_h
#define ltm_h


#include "lobject.h"


/*
* WARNING: if you change the order of this enumeration,
* grep "ORDER TM"
*/
typedef enum {
  TM_INDEX,
  TM_WRITEINDEX,
  TM_GC,
  TM_WEAK,
  TM_EQ,  /* last tag method with `fast' access */
  TM_ADD,
  TM_SUB,
  TM_MUL,
  TM_DIV,
  TM_MOD,
  TM_POW,
  TM_IPOW,
  TM_UNM,
  TM_LT,
  TM_LE,
  TM_CONCAT,
  TM_CALL,
  TM_INTDIV,  /* added 0.5.4 */
  TM_EEQ,     /* added 0.22.1 */
  TM_SIZE,    /* added 0.6.0 */
  TM_ABS,     /* added 0.7.0 */
  TM_FINITE,  /* added 0.9.2 */
  TM_IN,      /* added 0.11.0 */
  TM_SIN,     /* added 0.7.0 */
  TM_SQRT,    /* added 0.7.0 */
  TM_TAN,     /* added 0.7.0 */
  TM_LNGAMMA, /* added 0.9.0 */
  TM_QSADD,   /* added 0.12.3 */
  TM_SADD,    /* added 0.12.3 */
  TM_ARCTAN,  /* added 0.7.0 */
  TM_COS,     /* added 0.7.0 */
  TM_ENTIER,  /* added 0.7.0 */
  /* only 32 metamethods can be supported -
     no active metamethod handling can be programmed in lvm.c from here;
     change the manual if you add new tags */
  TM_INT,     /* added 0.7.0 */
  TM_EVEN,    /* added 0.7.1 */
  TM_EXP,     /* added 0.7.0 */
  TM_LN,      /* added 0.7.0 */
  TM_SIGN,    /* added 0.7.0 */
  TM_SINH,    /* added 0.23.0 */
  TM_COSH,    /* added 0.23.0 */
  TM_TANH,    /* added 0.23.0 */
  TM_ARCSIN,  /* added 0.27.0 */
  TM_ARCCOS,  /* added 0.27.0 */
  TM_RECIP,   /* added 2.1 RC 1 */
  TM_N        /* number of elements in the enum */
} TMS;



#define gfasttm(g,et,e) ((et) == NULL ? NULL : \
  ((et)->flags & (1u<<(e))) ? NULL : luaT_gettm(et, e, (g)->tmname[e]))

#define fasttm(l,et,e)   gfasttm(G(l), et, e)

LUAI_DATA const char *const luaT_typenames[];


LUAI_FUNC const TValue *luaT_gettm (Table *events, TMS event, TString *ename);
LUAI_FUNC const TValue *luaT_gettmbyobj (lua_State *L, const TValue *o,
                                                       TMS event);
LUAI_FUNC void luaT_init (lua_State *L);

#endif

