/*
** $Id: ltm.c,v 2.8 2006/01/10 12:50:00 roberto Exp $
** Tag methods
** See Copyright Notice in agena.h
*/


#include <string.h>

#define ltm_c
#define LUA_CORE

#include "agena.h"

#include "lobject.h"
#include "lstate.h"
#include "lstring.h"
#include "ltable.h"
#include "ltm.h"


/* typenames; grep "(GREP_POINT) types;" if you want to change their order or add new ones */

const char *const luaT_typenames[] = {
  "null", "boolean", "number", "complex",
  "string", "procedure", "userdata", "userdata", "thread", "table", "sequence", "pair", "set",
  "proto", "upval"  /* 0.4.0 */
};


void luaT_init (lua_State *L) {
  static const char *const luaT_eventname[] = {  /* ORDER TM */
    "__index", "__writeindex",
    "__gc", "__weak", "__eq",
    "__add", "__sub", "__mul", "__div", "__mod",
    "__pow", "__ipow", "__unm", "__lt", "__le",
    "__concat", "__call",
    /* additional Agena metamethods start from here, added 0.5.4 and later */
    "__intdiv", "__eeq", "__size", "__abs", "__finite",
    "__in", "__sin", "__sqrt", "__tan", "__lngamma",
    "__qsadd", "__sadd", "__arctan", "__cos", "__entier",
    /* metamethods not supported, add an operand here if it does not own a metamethod */
    "__int",  "__even", "__exp", "__ln", "__sign",
    "__sinh", "__cosh",  "__tanh", "__arcsin", "__arccos", "__recip"
  };
  int i;
  for (i=0; i<TM_N; i++) {
    G(L)->tmname[i] = luaS_new(L, luaT_eventname[i]);
    luaS_fix(G(L)->tmname[i]);  /* never collect these names */
  }
}


/*
** function to be used with macro "fasttm": optimized for absence of
** tag methods
*/
const TValue *luaT_gettm (Table *events, TMS event, TString *ename) {
  const TValue *tm = luaH_getstr(events, ename);
  lua_assert(event <= TM_EQ);
  if (ttisnil(tm)) {  /* no tag method? */
    events->flags |= cast_byte(1u<<event);  /* cache this fact */
    return NULL;
  }
  else return tm;
}


const TValue *luaT_gettmbyobj (lua_State *L, const TValue *o, TMS event) {
  Table *mt;
  switch (ttype(o)) {
    case LUA_TTABLE:
      mt = hvalue(o)->metatable;
      break;
    case LUA_TUSERDATA:
      mt = uvalue(o)->metatable;
      break;
    case LUA_TSEQ:
      mt = seqvalue(o)->metatable;
      break;
    case LUA_TSET:
      mt = usvalue(o)->metatable;
      break;
    case LUA_TPAIR:
      mt = pairvalue(o)->metatable;
      break;
    default:
      mt = G(L)->mt[ttype(o)];
  }
  return (mt ? luaH_getstr(mt, G(L)->tmname[event]) : luaO_nilobject);
}

