/*
** $Id: ltablib.c,v 1.38 2005/10/23 17:38:15 roberto Exp $
** Library for Table Manipulation
** See Copyright Notice in agena.h
*/


#include <stddef.h>
#include <math.h>  /* for fmod */

#define ltablib_c
#define LUA_LIB

#include "agena.h"

#include "agnxlib.h"
#include "agenalib.h"


#define aux_getn(L,n)   (luaL_checktype(L, n, LUA_TTABLE), luaL_getn(L, n))


static int maxn (lua_State *L) {
  lua_Number max = 0;
  luaL_checktype(L, 1, LUA_TTABLE);
  lua_pushnil(L);  /* first key */
  while (lua_next(L, 1)) {
    agn_poptop(L);  /* remove value */
    if (lua_type(L, -1) == LUA_TNUMBER) {
      lua_Number v = agn_tonumber(L, -1);  /* Agena 1.4.3/1.5.0 */
      if (v > max) max = v;
    }
  }
  lua_pushnumber(L, max);
  return 1;
}


static int tbl_allocate (lua_State *L) {  /* 22.12.2009 - 0.29.3 */
  int i, nargs;
  luaL_checktype(L, 1, LUA_TTABLE);
  nargs = lua_gettop(L);
  luaL_checkstack(L, nargs, "too many arguments");
  if (nargs == 1)
    luaL_error(L, "Error in " LUA_QS ": at least three arguments expected.", "tables.allocate");
  if (fmod(nargs, 2) == 0)
    luaL_error(L, "Error in " LUA_QS ": odd number of arguments expected.", "tables.allocate");
  lua_settop(L, nargs);
  for (i=3; i <= nargs; i=i+2) {
    lua_settable(L, 1);
  }
  return 0;
}


/*************************************************************************/
/* functions added for agena 0.5.3                                       */
/*************************************************************************/

/* tbl_indices: returns all keys of a table in a new table */

static int tbl_indices (lua_State *L) {
  int i = 0;
  luaL_checktype(L, 1, LUA_TTABLE);
  lua_createtable(L, agn_size(L, 1), 0);
  lua_pushnil(L);
  while (lua_next(L, 1) != 0)
    lua_rawsetikey(L, -3, ++i);
  return 1;
}


static int tbl_entries (lua_State *L) {  /* 0.30.1 */
  int i = 0;
  luaL_checktype(L, 1, LUA_TTABLE);
  lua_createtable(L, agn_size(L, 1), 0);
  lua_pushnil(L);
  while (lua_next(L, 1) != 0)
    lua_rawseti(L, -3, ++i);
  return 1;
}


/* }====================================================== */


static const luaL_Reg tab_funcs[] = {
  {"entries", tbl_entries},    /* added 0.30.1, 03.01.2010 */
  {"indices", tbl_indices},
  {"maxn", maxn},
  {"allocate", tbl_allocate},  /* added 0.29.2, 22.12.2009 */
  {NULL, NULL}
};


LUALIB_API int luaopen_table (lua_State *L) {
  luaL_register(L, LUA_TABLIBNAME, tab_funcs);
  return 1;
}


