/*
** $Id: llist.c, initiated February 02, 2013 $
** Linked list library
** See Copyright Notice in agena.h
*/


#include <stdlib.h>

#define llist_c
#define LUA_LIB

#include "agena.h"

#include "agnxlib.h"
#include "agenalib.h"


#if !(defined(LUA_DOS) || defined(__OS2__) || defined(LUA_ANSI))
#define AGENA_LLISTLIBNAME "llist"
LUALIB_API int (luaopen_llist) (lua_State *L);
#endif


static int llist_auxnode (lua_State *L) {
  lua_pushnil(L);
  agn_createpair(L, 1, -1);
  lua_remove(L, -2);
  lua_pushstring(L, "node");
  agn_setutype(L, -2, -1);
  agn_poptop(L);
  return 1;
}


static int llist_auxemptylist (lua_State *L) {
  agn_createtable(L, 0, 3);
  lua_rawsetstringnumber(L, -1, "sizeof", 0);
  lua_pushstring(L, "nodes");
  lua_pushnil(L); lua_pushnil(L);
  agn_createpair(L, -2, -1);
  lua_remove(L, -2); lua_remove(L, -2);
  lua_pushstring(L, "node");
  agn_setutype(L, -2, -1);
  agn_poptop(L);  
  lua_rawset(L, -3);
  lua_pushstring(L, "llist");
  agn_setutype(L, -2, -1);
  agn_poptop(L);
  lua_getglobal(L, "llist");
  lua_getfield(L, -1, "mt");
  lua_setmetatable(L, -3);
  agn_poptop(L);
  return 1;
}


static const luaL_Reg aux_funcs[] = {
  {"node", llist_auxnode},
  {"emptylist", llist_auxemptylist},
  {NULL, NULL}
};


static const luaL_Reg llistlib[] = {
  {NULL, NULL}
};


/*
** Open llist library
*/
LUALIB_API int luaopen_llist (lua_State *L) {
  luaL_register(L, AGENA_LLISTLIBNAME, llistlib);
  lua_newtable(L);  /* create table with auxiliar functions */
  luaL_register(L, NULL, aux_funcs);  /* put all functions in aux_funcs to this auxiliar table */
  lua_setfield(L, -2, "aux");
  return 1;
}

