/*
** $Id: llex.h,v 1.58 2006/03/23 18:23:32 roberto Exp $
** Lexical Analyzer
** See Copyright Notice in agena.h
*/

#ifndef llex_h
#define llex_h

#include "lobject.h"
#include "lzio.h"


#define FIRST_RESERVED   257

/* maximum length of a reserved word, currently 13 */
#define TOKEN_LEN   (sizeof("lightuserdata")/sizeof(char))


/* WARNING: if you change the order of this enumeration, grep "ORDER RESERVED" */
enum RESERVED {
  /* terminal symbols denoted by reserved words */
  TK_ABS = FIRST_RESERVED, TK_ALIAS, TK_AND, TK_ARCCOS, TK_ARCSIN, TK_ARCTAN, TK_AS, TK_ASSIGNED, TK_ATENDOF,
  TK_BOTTOM, TK_BREAK, TK_BY, TK_BYE,
  TK_CASE, TK_CATCH, TK_CHAR, TK_CLEAR, TK_CLS, TK_COPY, TK_COS, TK_COSH, TK_CREATE, TK_DEC, TK_DELETE, TK_DICT,
  TK_DO, TK_ELIF, TK_ELSE, TK_END, TK_ENTIER, TK_ENUM, TK_EPOCS, TK_ESAC, TK_EVEN, TK_EXP,
  TK_FAIL, TK_FALSE, TK_FI, TK_FILLED, TK_FINITE, TK_FLOAT, TK_FOR, TK_FROM, TK_GETHIGH, TK_GETLOW, TK_GLOBAL,
  TK_IF, TK_IMAG, TK_IMPORT, TK_IN, TK_INC, TK_INSERT, TK_INSTR, TK_INT, TK_INTERSECT, TK_INTO, TK_IS, TK_JOIN,
  TK_KEYS, TK_LEFT, TK_LN, TK_LNGAMMA, TK_LOCAL, TK_LOG, TK_LOWER, TK_MINUS, TK_NARGS, TK_NOT, TK_NULL,
  TK_OD, TK_OF, TK_ONSUCCESS, TK_OR, TK_POP, TK_PROC, TK_QSADD, TK_REAL, TK_RECIP, TK_REDO, TK_REPLACE, TK_RESTART, TK_RET, TK_RIGHT,
  TK_SADD, TK_SCOPE, TK_SEQ, TK_SETHIGH, TK_SETLOW, TK_SHIFT, TK_SI,
  TK_SIGN, TK_SIN, TK_SINH, TK_SIZE, TK_SKIP, TK_SPLIT, TK_SQRT, TK_SUBSET,
  TK_TAN, TK_TANH, TK_THEN, TK_TO, TK_TOP, TK_TRIM, TK_TRUE, TK_TRY, TK_TYPE, TK_TYPEOF,
  TK_UNASSIGNED, TK_UNION, TK_UNIQUE, TK_UNTIL, TK_UPPER, TK_VALUES, TK_WHILE, TK_XOR, TK_XSUBSET, TK_YRT,
  /* (GREP_POINT) types; if you change the order of the following keywords or add new ones, make sure that the types
     in ltm.c and agena.h are in the same order and that the definition of NUM_RESERVED (see below) may
     have to be be adjusted if you add new keywords right before the terminal symbols. */
  TK_TBOOLEAN, TK_TNUMBER, TK_TCOMPLEX, TK_TSTRING, TK_TPROCEDURE,
  TK_TUSERDATA, TK_TLIGHTUSERDATA, TK_TTHREAD, TK_TTABLE, TK_TSEQUENCE, TK_TPAIR, TK_TSET,
  /* other terminal symbols */
  TK_ASSIGN, TK_SEP, TK_CONCAT, TK_DOTS, TK_EQ, TK_GE, TK_LE, TK_NEQ, TK_EEQ, TK_IPOW, TK_OO, TK_OFTYPE, TK_NOTOFTYPE,
  TK_BAND, TK_BNOT, TK_BOR, TK_BXOR, TK_PERCENT, TK_PERCENTRATIO, TK_PERCENTADD, TK_PERCENTSUB, TK_ARROW, TK_LT2, TK_GT2, TK_DD,
  TK_NUMBER, TK_NAME, TK_STRING, TK_EOS
};

/* number of reserved words */
#define NUM_RESERVED   (cast(int, TK_TSET-FIRST_RESERVED+1))  /* agena 0.6.0 following */


/* array with token `names' */
LUAI_DATA const char *const luaX_tokens [];


typedef union {
  lua_Number r;
  TString *ts;
} SemInfo;  /* semantics information */


typedef struct Token {
  int token;
  SemInfo seminfo;
} Token;


typedef struct LexState {
  int current;  /* current character (charint) */
  int linenumber;  /* input line counter */
  int lastline;  /* line of last token `consumed' */
  Token t;  /* current token */
  Token lookahead;  /* look ahead token */
  struct FuncState *fs;  /* `FuncState' is private to the parser */
  struct lua_State *L;
  ZIO *z;  /* input stream */
  Mbuffer *buff;  /* buffer for tokens */
  TString *source;  /* current source name */
  char decpoint;  /* locale decimal point */
} LexState;


LUAI_FUNC void luaX_init (lua_State *L);
LUAI_FUNC void luaX_setinput (lua_State *L, LexState *ls, ZIO *z,
                              TString *source);
LUAI_FUNC TString *luaX_newstring (LexState *ls, const char *str, size_t l);
LUAI_FUNC void luaX_next (LexState *ls);
LUAI_FUNC void luaX_lookahead (LexState *ls);
LUAI_FUNC void luaX_lexerror (LexState *ls, const char *msg, int token);
LUAI_FUNC void luaX_syntaxerror (LexState *ls, const char *s);
LUAI_FUNC const char *luaX_token2str (LexState *ls, int token);

#endif
