/*
** $Id: linit.c,v 1.14 2005/12/29 15:32:11 roberto Exp $
** Initialization of libraries for agena.c
** See Copyright Notice in agena.h
*/


#define linit_c
#define LUA_LIB

#include "agena.h"
#include "agenalib.h"
#include "agnxlib.h"


static const luaL_Reg lualibs[] = {
  {"", luaopen_base},
  {LUA_LOADLIBNAME, luaopen_package},
  {LUA_TABLIBNAME, luaopen_table},
  {LUA_IOLIBNAME, luaopen_io},
  {LUA_OSLIBNAME, luaopen_os},
  {LUA_STRLIBNAME, luaopen_string},
  {LUA_MATHLIBNAME, luaopen_math},
  {LUA_DBLIBNAME, luaopen_debug},
  {AGENA_UTILSLIBNAME, luaopen_utils},
  {AGENA_BINIOLIBNAME, luaopen_binio},
  {AGENA_RTABLELIBNAME, luaopen_rtable},
  {AGENA_ENVIRONLIBNAME, luaopen_environ},
#if defined(LUA_DOS) || defined(__OS2__) || defined(LUA_ANSI)
  {AGENA_ADSLIBNAME, luaopen_ads},
  {AGENA_BAGSLIBNAME, luaopen_bags},
  {AGENA_CALCLIBNAME, luaopen_calc},
  {AGENA_LINALGLIBNAME, luaopen_linalg},
  {AGENA_MAPMLIBNAME, luaopen_mapm},
  {AGENA_STATSLIBNAME, luaopen_stats},
  {AGENA_XBASELIBNAME, luaopen_xbase},
  {AGENA_ASTROLIBNAME, luaopen_astro},
  {AGENA_SKYCRANELIBNAME, luaopen_skycrane},
  {AGENA_LLISTLIBNAME, luaopen_llist},
#endif
#if defined(LUA_DOS)
  {AGENA_LZLIBLIBNAME, luaopen_gzip},
#endif
  {NULL, NULL}
};


LUALIB_API void luaL_openlibs (lua_State *L) {
  const luaL_Reg *lib = lualibs;
  for (; lib->func; lib++) {
    lua_pushcfunction(L, lib->func);
    lua_pushstring(L, lib->name);
    lua_call(L, 1, 0);
  }
}