/*
** $Id: lcode.h,v 1.48 2006/03/21 19:28:03 roberto Exp $
** Code generator for Lua/Agena
** See Copyright Notice in agena.h
*/

#ifndef lcode_h
#define lcode_h

#include "llex.h"
#include "lobject.h"
#include "lopcodes.h"
#include "lparser.h"


/*
** Marks the end of a patch list. It is an invalid value both as an absolute
** address, and as a list link (would link an element to itself).
*/
#define NO_JUMP (-1)


/*
** grep "ORDER OPR" if you change these enums
*/
typedef enum BinOpr {
  OPR_ADD, OPR_SUB, OPR_MUL, OPR_DIV, OPR_MOD,
  OPR_POW, OPR_IPOW,
  OPR_INTDIV, OPR_CONCAT,  /* added 0.9.2 & 0.5.4 */
  OPR_NE, OPR_EQ,
  OPR_LT, OPR_LE, OPR_GT, OPR_GE,
  OPR_AND, OPR_OR,
  OPR_IN,          /* added 0.7.1 */
  OPR_TSUBSET,     /* added 0.6.0 */
  OPR_TXSUBSET,    /* added 0.9.1 */
  OPR_TUNION,      /* added 0.6.0 */
  OPR_TMINUS,      /* added 0.6.0 */
  OPR_TINTERSECT,  /* added 0.6.0 */
  OPR_SPLIT,       /* added 0.6.0 */
  OPR_SHIFT,       /* added 0.9.1 */
  OPR_PAIR,        /* added 0.11.1 */
  OPR_COMPLEX,     /* added 0.12.0 */
  OPR_TEEQ,        /* added 0.22.0 */
  OPR_XOR,         /* added 0.27.0 */
  OPR_ATENDOF,     /* added 0.27.0 */
  OPR_BAND,        /* added 0.27.0 */
  OPR_BOR,         /* added 0.27.0 */
  OPR_BXOR,        /* added 0.27.0 */
  OPR_TOFTYPE,     /* added 1.3.0 */
  OPR_TNOTOFTYPE,  /* added 1.3.0 */
  OPR_PERCENT,     /* added 1.10.6 */
  OPR_PERCENTRATIO,/* added 1.11.4 */
  OPR_PERCENTADD,  /* added 1.11.3 */
  OPR_PERCENTSUB,  /* added 1.11.3 */
  OPR_NOBINOPR
} BinOpr;


/* do not move OPR_ABS to another position as it controls general precedence */
typedef enum UnOpr { OPR_MINUS, OPR_NOT, OPR_LEN, OPR_ABS, OPR_ASSIGNED,
  OPR_TUNIQUE, OPR_TYPE, OPR_TSADD, OPR_TQSADD, OPR_ARCTAN, OPR_BOTTOM, OPR_CHAR, OPR_COS, OPR_COSH,
  OPR_DIMSEQ, OPR_DIMTAB, OPR_DIMDICT, OPR_DIMSET, OPR_ENTIER, OPR_EVEN, OPR_EXP, OPR_FINITE,
  OPR_FLOAT, OPR_LNGAMMA, OPR_IMAG, OPR_INT, OPR_JOIN, OPR_LEFT, OPR_LN, OPR_LOG, OPR_LOWER,
  OPR_MAP, OPR_NARGS, OPR_NEWSEQ, OPR_NEWUSET, OPR_REAL, OPR_REPLACE, OPR_RIGHT,
  OPR_SIGN, OPR_SIN, OPR_SINH, OPR_SQRT, OPR_TAN, OPR_TANH, OPR_TOP, OPR_TRIM, OPR_UPPER, OPR_TCOPY,
  OPR_TFILLED, OPR_TYPEOF, OPR_UNASSIGNED, OPR_ARCSIN, OPR_ARCCOS, OPR_RECIP, OPR_BNOT,
  OPR_GETHIGH, OPR_GETLOW, OPR_SETHIGH, OPR_SETLOW, OPR_INSTR, OPR_VALUES, OPR_NOUNOPR
} UnOpr;


#define getcode(fs,e)   ((fs)->f->code[(e)->u.s.info])

#define luaK_codeAsBx(fs,o,A,sBx)   luaK_codeABx(fs,o,A,(sBx)+MAXARG_sBx)

#define luaK_setmultret(fs,e)   luaK_setreturns(fs, e, LUA_MULTRET)

LUAI_FUNC int luaK_codeABx (FuncState *fs, OpCode o, int A, unsigned int Bx);
LUAI_FUNC int luaK_codeABC (FuncState *fs, OpCode o, int A, int B, int C);
LUAI_FUNC void luaK_fixline (FuncState *fs, int line);
LUAI_FUNC void luaK_nil (FuncState *fs, int from, int n);
LUAI_FUNC void luaK_reserveregs (FuncState *fs, int n);
LUAI_FUNC void luaK_checkstack (FuncState *fs, int n);
LUAI_FUNC int luaK_stringK (FuncState *fs, TString *s);
LUAI_FUNC int luaK_numberK (FuncState *fs, lua_Number r);
LUAI_FUNC void luaK_dischargevars (FuncState *fs, expdesc *e);
LUAI_FUNC int luaK_exp2anyreg (FuncState *fs, expdesc *e);
LUAI_FUNC void luaK_exp2nextreg (FuncState *fs, expdesc *e);
LUAI_FUNC void luaK_exp2val (FuncState *fs, expdesc *e);
LUAI_FUNC int luaK_exp2RK (FuncState *fs, expdesc *e);
LUAI_FUNC void luaK_self (FuncState *fs, expdesc *e, expdesc *key);
LUAI_FUNC void luaK_indexed (FuncState *fs, expdesc *t, expdesc *k);
LUAI_FUNC void luaK_goiftrue (FuncState *fs, expdesc *e);
LUAI_FUNC void luaK_storevar (FuncState *fs, expdesc *var, expdesc *e);
LUAI_FUNC void luaK_setreturns (FuncState *fs, expdesc *e, int nresults);
LUAI_FUNC void luaK_setoneret (FuncState *fs, expdesc *e);
LUAI_FUNC int luaK_jump (FuncState *fs);
LUAI_FUNC void luaK_ret (FuncState *fs, int first, int nret);
LUAI_FUNC void luaK_patchlist (FuncState *fs, int list, int target);
LUAI_FUNC void luaK_patchtohere (FuncState *fs, int list);
LUAI_FUNC void luaK_concat (FuncState *fs, int *l1, int l2);
LUAI_FUNC int luaK_getlabel (FuncState *fs);
LUAI_FUNC void luaK_prefix (FuncState *fs, UnOpr op, expdesc *v);
LUAI_FUNC void luaK_infix (FuncState *fs, BinOpr op, expdesc *v);
LUAI_FUNC void luaK_posfix (FuncState *fs, BinOpr op, expdesc *v1, expdesc *v2);
LUAI_FUNC void luaK_setlist (FuncState *fs, int base, int nelems, int tostore);

LUAI_FUNC void codearith (FuncState *fs, OpCode op, expdesc *e1, expdesc *e2);  /* added 0.5.2 */
LUAI_FUNC void luaK_goiffalse (FuncState *fs, expdesc *e);  /* added 0.5.3 */
LUAI_FUNC void codecompcase (FuncState *fs, int base, int nargs, expdesc *e);  /* added 0.6.0 */
LUAI_FUNC void luaK_isoperation (FuncState *fs, expdesc *e, int base);  /* added 0.7.1 */
LUAI_FUNC int codearithbypass (FuncState *fs, int flag, expdesc *e1, UnOpr fn);  /* 0.9.0/0.9.1 */
LUAI_FUNC void freeexp (FuncState *fs, expdesc *e);

#endif
