/*
** $Id: agnhlps.h $
** C Helper routines
** See Copyright Notice in agena.h
** initiated Alexander Walz, July 20, 2007
*/

#ifndef agnhlps_h
#define agnhlps_h

#include <stdio.h>
#include "agena.h"
#include "agncmpt.h"

#ifndef uint64_t  /* 1.0.1a patch to facilitate compilation in certain Linux environments */
  #define uint64_t  unsigned long long
#endif

/* misc functions */

LUALIB_API double tools_intpow (double x, int n);

/* used in packages `ads` */

LUALIB_API void tools_quicksort (off64_t v[], int left, int right);

/* used in packages `stats` */

LUALIB_API void tools_dquicksort (double v[], long int left, long int right);

LUALIB_API int pixel_qsort (double *pix_arr, int npix);

LUALIB_API double tools_kth_smallest (double a[], long int n, long int k);

/* Dr. F.H.Toor's and my database C functions used in packages `base` and `phonetiqs` */

LUALIB_API int my_open (const char *file);
LUALIB_API int my_roopen (const char *file);
LUALIB_API int my_create (const char *file) ;
LUALIB_API int my_close (int hnd);
LUALIB_API int my_seek (int hnd, int32_t pos);
LUALIB_API off_t my_lof (int hnd);
LUALIB_API void my_read (int hnd, void *data, size_t size);
LUALIB_API int32_t my_readl (int hnd);
LUALIB_API char my_readc (int hnd);
LUALIB_API void my_write (int hnd, void *data, size_t size);
LUALIB_API void my_writel (int hnd, int32_t data);
LUALIB_API void my_writec (int hnd, char data);
LUALIB_API int my_lock (int hnd, off64_t start, off64_t size);
LUALIB_API int my_unlock (int hnd, off64_t start, off64_t size);
LUALIB_API void my_move (int hnd, int32_t fpos, int32_t tpos, int32_t size);
LUALIB_API void my_expand (int hnd, int mrc, int cnt, int count);
LUALIB_API off64_t my_fpos (int hnd);

LUALIB_API size_t sec_read (int hnd, void *data, size_t size);
LUALIB_API int32_t sec_readl (int hnd, ssize_t *success);
LUALIB_API int32_t sec_readul (int hnd, ssize_t *success);

/* get keystroke function, does not work in Haiku */
#if defined(__unix__) || defined(__APPLE__)
LUALIB_API int getch (void);
LUALIB_API int kbhit (void);
#endif


LUALIB_API int tools_cwd (char *buffer);

/* Endian functions */

LUALIB_API char tools_endian (void);

LUALIB_API uint64_t tools_swapdouble (double n);
LUALIB_API double tools_unswapdouble (uint64_t n);
LUALIB_API void tools_swaplong (long *n);
LUALIB_API void tools_swapint32_t (int32_t *n);

/* IEEE simulators */

LUALIB_API int tools_isfinite (const double x);
LUALIB_API int tools_isnan (const double x);
LUALIB_API double tools_nan (void);

/* numerical functions */

LUALIB_API double tools_sunpow (double x, double y);


/* some constants */

#undef PI
#define PI (3.14159265358979323846)

#undef PI2  /* Pi*2 */
#define PI2 (6.283185307179586476926)

#undef PIO2  /* Pi/2 */
#define PIO2 (1.570796326794896619232)

#undef PIO4
#define PIO4 (0.7853981633974483096158)

#undef _E
#define _E (2.71828182845904523536)

#undef AGN_EPSILON
#define AGN_EPSILON  1.4901161193847656e-08  /* suited for doubles */

#undef RADIANS_PER_DEGREE
#define RADIANS_PER_DEGREE (PI/180.0)

#undef EULERGAMMA
#define EULERGAMMA (0.57721566490153286061)

LUALIB_API double csgn (double a, double b);

LUALIB_API char *charreplace (char *s, char from, char to, int flag);
LUALIB_API char *concat (const char *s1, ...);
LUALIB_API int glob (const char *pat, const char *str);
LUALIB_API char *substr (const char *str, const size_t begin, const size_t end, int *error);
#define substrl(s, beg, l, err) substr(s, beg, beg + l - 1, err)

/* char *chardelete (char *s, char from); */

/* code taken from: @(#)s_nextafter.c 5.1 93/09/24
 *
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 *
 * IEEE functions
 *   nextafter(x,y)
 *   return the next machine floating-point number of x in the direction toward y.
 *   Special cases:
 *
 * Leave this code here and do not move it to agnconf.h etc. for incorrect results would be returned.
 *
 */

/* Get two 32 bit ints from a double.  */

#define EXTRACT_WORDS(ix0,ix1,d) \
do { \
  ieee_double_shape_type ew_u; \
  ew_u.value = (d); \
  (ix0) = ew_u.parts.msw; \
  (ix1) = ew_u.parts.lsw; \
} while (0)

#define GET_HI(ix0,d) \
do { \
  ieee_double_shape_type ew_u; \
  ew_u.value = (d); \
  (ix0) = ew_u.parts.msw; \
} while (0)

#define GET_LO(ix1,d) \
do { \
  ieee_double_shape_type ew_u; \
  ew_u.value = (d); \
  (ix1) = ew_u.parts.lsw; \
} while (0)

/* Set a double from two 32 bit ints.  */

#define INSERT_WORDS(d,ix0,ix1) \
do { \
  ieee_double_shape_type iw_u; \
  iw_u.parts.msw = (ix0); \
  iw_u.parts.lsw = (ix1); \
  (d) = iw_u.value; \
} while (0)


/* ISO 8859/1 Latin-1 alphabetic and upper and lower case bit vector tables.

   Taken from the entropy utility ENT written by John Walker, January 28th, 2008,
   Fourmilab, http://www.fourmilab.ch.

   This software is in the public domain. Permission to use, copy, modify, and distribute this software
   and its documentation for any purpose and without fee is hereby granted, without any conditions or
   restrictions. This software is provided as is without express or implied warranty. */

LUALIB_API unsigned char isoalpha[32], isoupper[32], isolower[32];

#define isISOspace(x)	((isascii((uchar (x))) && isspace((uchar (x)))) || ((x) == 0xA0))
#define isISOalpha(x)	((isoalpha[((uchar (x))) / 8] & (0x80 >> (((uchar (x))) % 8))) != 0)
#define isISOupper(x)	((isoupper[((uchar (x))) / 8] & (0x80 >> (((uchar (x))) % 8))) != 0)
#define isISOlower(x)	((isolower[((uchar (x))) / 8] & (0x80 >> (((uchar (x))) % 8))) != 0)
#define isISOprint(x)   ((((x) >= ' ') && ((x) <= '~')) || ((x) >= 0xA0))
#define toISOupper(x)   (isISOlower(x) ? (isascii((uchar (x))) ?  \
                            toupper(x) : ((((uchar (x)) != 0xDF) && \
                            ((uchar (x)) != 0xFF)) ? \
			                ((uchar (x)) - 0x20) : (x))) : (x))
#define toISOlower(x)   (isISOupper(x) ? (isascii((uchar (x))) ?  \
                            tolower(x) : ((uchar (x)) + 0x20)) \
			                : (x))

LUALIB_API char *latin9_to_utf8 (const char *string);
LUALIB_API char *utf8_to_latin9 (const char *string);
LUALIB_API int is_utf8 (const char *string);
LUALIB_API size_t size_utf8 (const char *str);

#define dsign(x)     ( ((x) == 0) ? 0 : (((x) < 0) ? -1 : 1) )
#define intdiv(a,b) (((b) != 0) ? (dsign((a))*dsign((b))*floor(fabs((a)/(b)))) : (AGN_NAN) )  /* more exact for neg values */

#define isleapyear(y)  (((y) % 4 == 0 && !((y) % 100 == 0)) || ((y) % 400 == 0))

LUALIB_API int tools_checkdatetime (int year, int month, int day, int hour, int minute, int second);

LUALIB_API int tools_isnumericstring (const char *str);

LUALIB_API char *strreplace (const char *original, const char *pattern, const char *replacement);

LUALIB_API char *my_dtoa (double x);

#define xfree(v) { free(v); v = NULL; }

#endif

