/* compatibility header file */

#include "agnhlps.h"

#ifndef agncmpt_h
#define agncmpt_h

/* SuSE 10.1 Linux and DJGPP do not know trunc */
#ifndef trunc
#  define trunc(x)  ( ((x)>0) ? floor((x)) : ceil((x)) )
#endif

/* SuSE 10.3 Linux does not know log2 */
#ifndef log2
#  define log2(x)  ( ((x))>0 ? log((x))/log(2) : AGN_NAN )
#endif

/* Sparc Solaris GCC 3.4.6 does not know ISO C99's `isfinite` */
#ifndef isfinite
#  define isfinite tools_isfinite
#endif

/* needed to compile under Solaris; orig in MinGW: 0x8000 */
#if !defined(_WIN32) && !defined(LUA_DOS) && !defined(__OS2__)
#define O_BINARY      0x0000
#endif

/* at least in GCC there are problems with fmax, see http://gcc.gnu.org/ml/gcc-bugs/2004-01/msg00620.html:
  `The symptom is that values of the mathematical functions fmaxf, fminf, fmax, fmin, fmaxl, fminl are
   all wrong. This makes the results of some numerical computations junks.` - 0.26.4. */
#define fMax(a, b)  (((a) > (b)) ? (a) : (b))  /* substitute */

/* define constant `undefined` */
#ifdef NAN
#define AGN_NAN NAN
#elif defined(INFINITY)
#define AGN_NAN (INFINITY/INFINITY)
#else
#define AGN_NAN (tools_nan())
#endif

/* define complex unit I, which natively is not known to Solaris */
#ifdef __unix__
#undef _Complex_I
#define _Complex_I   (0.0F + 1.0iF)
#undef I
#define I   _Complex_I
#endif

/* The floating-point expression evaluation method, not known in MinGW/GCC 3.4.6
       -1  indeterminate
        0  evaluate all operations and constants just to the range and
           precision of the type
        1  evaluate operations and constants of type float and double
           to the range and precision of the double type, evaluate
           long double operations and constants to the range and
           precision of the long double type
        2  evaluate all operations and constants to the range and
           precision of the long double type;
   According to various newsgroup, its value is always 0. */
#ifndef FLT_EVAL_METHOD
#define FLT_EVAL_METHOD 0
#endif


#ifndef math_opt_barrier
#define math_opt_barrier(x) \
({ __typeof (x) __x = x; __asm ("" : "+m" (__x)); __x; })
#define math_force_eval(x) __asm __volatile ("" : : "m" (x))
#endif

#ifndef uint64_t
#  define uint64_t  unsigned long long
#endif

/* not known in Linux, DOS, and OS/2; whether GCC 3.4.6 for OS/2 really suipports file sizes > 2^31 bytes is unknown. */
/* #ifndef off64_t
#  define off64_t off_t
#endif */

#ifndef LUA_DOS
  #include <stdint.h>     /* for int32_t */
  #include <sys/types.h>  /* for off_t & off64_t */
  #ifndef off64_t
    #define off64_t off_t
  #endif
  #ifndef lseek64
    #define lseek64 lseek
  #endif
#else
  #ifndef off_t
    #define off_t long
  #endif
  #ifndef int32_t
    #define int32_t long
  #endif
  #ifndef off64_t
    #define off64_t	long long
  #endif
  #ifndef ssize_t
    #define ssize_t	long
  #endif
#endif


/* not known in Linux and OS/2; whether GCC 3.4.6 for OS/2 really suipports file sizes > 2^31 bytes is unknown. */
#ifndef ftello64
  #define ftello64 ftell
#endif

/* not known in Linux and OS/2; whether GCC 3.4.6 for OS/2 really suipports file sizes > 2^31 bytes is unknown. */
#ifndef lseek64
  #define lseek64 lseek
#endif


/* use lrint only to check for an integer or float; do not use lrint in other expressions since lrint does not
   round toward 0. */
#ifdef _WIN32
#define TRUNC	lrint
#else
#define TRUNC	trunc
#endif


#endif

