# RPM building file for OpenSUSE 10.3
# ! build Agena in /home/proglang/agena !
Summary: Agena Programming Language
Name: agena
Version: 2.1.0
Release: 1
# change Release number in build.sh file, as well.
#Source0: %{name}-%{version}-src.tar.gz
License: GPL v2
Group: Development/Languages
Source: http://downloads.sourceforge.net/agena/%{name}-%{version}-src.tar.gz
Summary: Agena is a procedural programming language.
#BuildRequires: ncurses, readline, freetype, fontconfig, libpng, zlib, expat, jpeg, gd, iconv, intl, xpm
#libiconv, xpm, libintl, libgd
#BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}
BuildRoot: %{_tmppath}/%{name}-%{version}
URL: http://agena.sourceforge.net
Packager: Alexander Walz
Vendor: Alexander Walz
Provides: agena libagena.so libagena.a
%description
Agena is an easy-to-learn procedural programming language designed to be used
in scientific, educational, linguistic, graphical, network, and many other
applications, including scripting.

Its syntax resembles very simplified Algol 68 with elements taken from Lua
and SQL.

Agena provides fast real and complex arithmetics, efficient text processing,
flexible data structures, intelligent procedures and package management, plus
various configuration facilities.
%prep
# unpack the source and cd into the SOURCE directory
%setup -q
%build
make config
make linux
%install
make install
# for sanity protection, make sure the Buildroot is empty
rm -rf $RPM_BUILD_ROOT
%makeinstall
mkdir -p $RPM_BUILD_ROOT/usr/agena
mkdir -p $RPM_BUILD_ROOT/usr/agena/lib
mkdir -p $RPM_BUILD_ROOT/usr/agena/doc
mkdir -p $RPM_BUILD_ROOT/usr/agena/share
mkdir -p $RPM_BUILD_ROOT/usr/agena/schemes
mkdir -p $RPM_BUILD_ROOT/usr/local
mkdir -p $RPM_BUILD_ROOT/usr/local/bin
mkdir -p $RPM_BUILD_ROOT/usr/local/lib
mkdir -p $RPM_BUILD_ROOT/usr/local/include
mkdir -p $RPM_BUILD_ROOT/usr/local/include/agena
mkdir -p $RPM_BUILD_ROOT/usr/lib
mkdir -p $RPM_BUILD_ROOT/usr/lib/pkgconfig
cp /home/proglang/agena/doc/agena-crashcourse.pdf $RPM_BUILD_ROOT/usr/agena/doc
#cp /home/proglang/agena/doc/agena-crashcourse.ppt $RPM_BUILD_ROOT/usr/agena/doc
#cp /home/proglang/agena/doc/Agena.lwp $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/doc/agena.pdf $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/doc/agena.xls $RPM_BUILD_ROOT/usr/agena/doc
cp /home/proglang/agena/installers/rpmsuse/agena.pc $RPM_BUILD_ROOT/usr/lib/pkgconfig
cp /home/proglang/agena/lib/ads.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ads.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/.agenainit.sample $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/ansi.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/bags.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/bags.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/calc.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/calc.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/clock.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gdi.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gdi.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mapm.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/mapm.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gzip.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/gzip.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/library.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/compat.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/compat.0.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/linalg.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/linalg.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/stats.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/stats.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/skycrane.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/skycrane.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/xbase.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/xbase.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/xml.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/xml.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/net.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/net.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/fractals.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/fractals.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/astro.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/astro.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/llist.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/llist.so $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/lib/div.agn $RPM_BUILD_ROOT/usr/agena/lib
cp /home/proglang/agena/schemes/agena.lang $RPM_BUILD_ROOT/usr/agena/schemes
cp /home/proglang/agena/schemes/agena.sch $RPM_BUILD_ROOT/usr/agena/schemes
cp /home/proglang/agena/schemes/agena.xml $RPM_BUILD_ROOT/usr/agena/schemes
cp /home/proglang/agena/schemes/agena.dat $RPM_BUILD_ROOT/usr/agena/schemes
cp /home/proglang/agena/schemes/nedit.rc $RPM_BUILD_ROOT/usr/agena/schemes
cp /home/proglang/agena/schemes/readme.txt $RPM_BUILD_ROOT/usr/agena/schemes
cp /home/proglang/agena/share/agena.ico $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena.png $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena128x128.ico $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena128x128.png $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena64x64.ico $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena64x64.png $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena8b.gif $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agena8b.ico $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agenasmall.ico $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/share/agenasmall.png $RPM_BUILD_ROOT/usr/agena/share
cp /home/proglang/agena/src/agena $RPM_BUILD_ROOT/usr/local/bin
cp /home/proglang/fltk-1.1.10/editor/agenaedit $RPM_BUILD_ROOT/usr/local/bin
cp /home/proglang/agena/src/agena.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agnxlib.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agenalib.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agncmpt.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agncfg.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agnconf.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agnhlps.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agnt64.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agnt64_c.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/agnt64_l.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/change.log $RPM_BUILD_ROOT/usr/agena
cp /home/proglang/agena/src/cephes.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/m_apm.h $RPM_BUILD_ROOT/usr/local/include/agena
cp /home/proglang/agena/src/libagena.a $RPM_BUILD_ROOT/usr/local/lib
cp /home/proglang/agena/src/libagena.so $RPM_BUILD_ROOT/usr/local/lib
cp /home/proglang/agena/src/licence $RPM_BUILD_ROOT/usr/agena
chmod -R 755 $RPM_BUILD_ROOT/usr/agena
chmod -R 755 $RPM_BUILD_ROOT/usr/local/include/agena
chmod 755 $RPM_BUILD_ROOT/usr/local/bin/agena
chmod 755 $RPM_BUILD_ROOT/usr/local/lib/libagena.a
chmod 755 $RPM_BUILD_ROOT/usr/local/lib/libagena.so
chmod 755 $RPM_BUILD_ROOT/usr/lib/pkgconfig/agena.pc
%clean
rm -rf $RPM_BUILD_ROOT
%files
%defattr(-,root,root)
/usr/agena/doc
/usr/agena/share
/usr/agena/schemes
# do not remove agena.ini file, so do not delete /usr/agena/lib subdirectory completely
/usr/agena/change.log
/usr/agena/licence
/usr/agena/lib/ads.agn
/usr/agena/lib/ads.so
/usr/agena/lib/.agenainit.sample
/usr/agena/lib/ansi.agn
/usr/agena/lib/bags.agn
/usr/agena/lib/bags.so
/usr/agena/lib/calc.agn
/usr/agena/lib/calc.so
/usr/agena/lib/clock.agn
/usr/agena/lib/gdi.agn
/usr/agena/lib/gdi.so
/usr/agena/lib/mapm.agn
/usr/agena/lib/mapm.so
/usr/agena/lib/gzip.agn
/usr/agena/lib/gzip.so
/usr/agena/lib/library.agn
/usr/agena/lib/compat.agn
/usr/agena/lib/compat.0.agn
/usr/agena/lib/linalg.agn
/usr/agena/lib/linalg.so
/usr/agena/lib/stats.agn
/usr/agena/lib/stats.so
/usr/agena/lib/skycrane.agn
/usr/agena/lib/skycrane.so
/usr/agena/lib/xbase.agn
/usr/agena/lib/xbase.so
/usr/agena/lib/xml.agn
/usr/agena/lib/xml.so
/usr/agena/lib/net.agn
/usr/agena/lib/net.so
/usr/agena/lib/fractals.agn
/usr/agena/lib/fractals.so
/usr/agena/lib/astro.agn
/usr/agena/lib/astro.so
/usr/agena/lib/llist.agn
/usr/agena/lib/llist.so
/usr/agena/lib/div.agn
/usr/local/include/agena
/usr/local/lib/libagena.a
/usr/local/lib/libagena.so
/usr/lib/pkgconfig/agena.pc
/usr/local/bin/agena
/usr/local/bin/agenaedit

#%doc /usr/local/info/agena.info
#%doc %attr(0444,root,root) /usr/local/man/man1/indent.1
#%doc COPYING AUTHORS README NEWS
%post
#cd /usr/lib
#ln -sf ./libreadline.so.5.2 ./libreadline.so.5
#ln -sf ./libhistory.so.5.2 ./libhistory.so.5
#ln -sf ./libncurses.so.5.6 ./libncurses.so.5
echo ""
echo "The Agena binary has been put in the /usr/local/bin folder."
echo ""
echo "The Agena library files libagena.* have been put in the /usr/local/lib folder."
echo ""
echo "The Agena *.h include files have been put in the /usr/local/include/agena"
echo "folder."
echo ""
echo "All other Agena files including the manual may be found in /usr/agena."
echo ""
echo "The main Agena library folder is /usr/agena/lib."
echo ""
