;NSIS Setup Script
;--------------------------------

!ifndef VERSION
  !define VER_MAJOR '2'
  !define VER_MINOR '1'
  !define VER_REVISION '0'
  !define VERSION '${VER_MAJOR}.${VER_MINOR}.${VER_REVISION}'
!endif

; grep VER_SUBREVISION to activate or deactivate Library Updates

!ifndef WEBSITE
  !define WEBSITE 'http://agena.sourceforge.net'
!endif

;--------------------------------
;Configuration

!ifdef OUTFILE
  OutFile "${OUTFILE}"
!else
  OutFile ..\..\agena-${VERSION}-win32-setup.exe
!endif

;Request application privileges for Windows Vista
RequestExecutionLevel user

SetCompressor /SOLID lzma

InstType "Full"
InstType "Standard"
;InstType "Minimal"

InstallDir $PROGRAMFILES\Agena
InstallDirRegKey HKLM Software\AGENA ""

RequestExecutionLevel admin

;--------------------------------

;Multi-user defines

!define MULTIUSER_EXECUTIONLEVEL Admin
!define MULTIUSER_INSTALLMODE_DEFAULT_CURRENTUSER
!define MULTIUSER_MUI

;Header Files

!include MultiUser.nsh
!include "MUI2.nsh"
!include "Sections.nsh"
!include "LogicLib.nsh"
!include "Memento.nsh"
!include "WordFunc.nsh"

!include "EnvVarUpdate.nsh"

;--------------------------------
;Functions

!ifdef VER_MAJOR & VER_MINOR & VER_REVISION

  !insertmacro VersionCompare

!endif

;--------------------------------
;Definitions

!define SHCNE_ASSOCCHANGED 0x8000000
!define SHCNF_IDLIST 0

;--------------------------------
;Configuration

;Names
Name "Agena"
Caption "Agena ${VERSION} Setup"

BGGradient 000000 800000 FFFFFF
InstallColors FF8080 000030
XPStyle off

!define MUI_HEADERIMAGE_BITMAP "..\nsis\banner.bmp"

!define MUI_COMPONENTSPAGE_CHECKBITMAP "${NSISDIR}\Contrib\Graphics\Checks\classic.bmp"

!define MUI_ICON "..\..\share\agena.ico"
;!define MUI_UNICON "..\..\share\agena.ico"

;Memento Settings
!define MEMENTO_REGISTRY_ROOT HKLM
!define MEMENTO_REGISTRY_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\AGENA"

;Interface Settings
!define MUI_ABORTWARNING

!define MUI_HEADERIMAGE
!define MUI_WELCOMEFINISHPAGE_BITMAP "..\nsis\logo.bmp"

!define MUI_COMPONENTSPAGE_SMALLDESC

;Pages
!define MUI_WELCOMEPAGE_TITLE "Welcome to the$\r$\nAgena ${VERSION} Setup Wizard"
!define MUI_WELCOMEPAGE_TEXT "This wizard will guide you through the installation of the$\r$\nAgena ${VERSION} Interpreter.$\r$\n$\rAgena is an easy-to-learn procedural programming language designed to be used in scientific, educational, linguistic, network, and many other applications.$\r$\n$\rIts syntax looks like very simplified Algol 68 with elements taken from Lua and SQL.$\r$\n$\rThe implementation is based on the original Lua 5.1 sources written by Roberto Ierusalimschy, Luiz Henrique de Figueiredo, and Waldemar Celes.$\r$\n$\r$\n$_CLICK"

;LicenseForceSelection checkbox "I accept."

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "..\..\src\licence"
!ifdef VER_MAJOR & VER_MINOR & VER_REVISION
Page custom PageReinstall PageLeaveReinstall
!endif

!insertmacro MUI_PAGE_WELCOME
;  !define MUI_PAGE_CUSTOMFUNCTION_PRE multiuser_pre_func
!insertmacro MULTIUSER_PAGE_INSTALLMODE

!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY

;-----------------------------------------------------------------------------------------
;Start Menu Folder Page
;-----------------------------------------------------------------------------------------
;Variables
Var StartMenuFolder
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKCU"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "Software\Agena"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "Start Menu Folder"

!insertmacro MUI_PAGE_STARTMENU Application $StartMenuFolder

;-----------------------------------------------------------------------------------------
; Installation Page
;-----------------------------------------------------------------------------------------
ShowInstDetails show
!insertmacro MUI_PAGE_INSTFILES

;-----------------------------------------------------------------------------------------
; Finish page
;-----------------------------------------------------------------------------------------
!define MUI_FINISHPAGE_LINK "Visit the Agena site for the latest news, add-ons and updates."
!define MUI_FINISHPAGE_LINK_LOCATION "${WEBSITE}"

!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_RUN "$INSTDIR\bin\agena.exe"
!define MUI_FINISHPAGE_NOREBOOTSUPPORT

!define MUI_FINISHPAGE_SHOWREADME
!define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
!define MUI_FINISHPAGE_SHOWREADME_TEXT "View manual"
!define MUI_FINISHPAGE_SHOWREADME_FUNCTION ShowReleaseNotes

!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

;--------------------------------
;Languages

!insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Installer Sections


${MementoSection} "Agena Core Files (required)" SecCore

  ;SetDetailsPrint textonly
  SetDetailsPrint both
  DetailPrint "Installing Agena Core Files ..."
  ;SetDetailsPrint listonly

  SectionIn 1 2 RO
  SetOutPath $INSTDIR
  RMDir /r $SMPROGRAMS\Agena

  SetOutPath $INSTDIR\bin
  File ..\..\src\agena.exe
  File ..\..\share\agena.ico
  File ..\..\src\agena.dll
  File ..\..\src\licence
  File ..\..\change.log

  SetOutPath $INSTDIR\lib
  File ..\..\lib\library.agn
  File ..\..\lib\ansi.agn
  File ..\..\lib\compat.agn
  File ..\..\lib\compat.0.agn
  File ..\..\lib\agena.ini.sample

${MementoSectionEnd}

${MementoSection} "AgenaEdit" SecAgenaEdit
  SectionIn 1 2

  SetOutPath $INSTDIR\bin
  File ..\..\..\fltk-1.1.10\editor\agenaedit.exe

${MementoSectionEnd}


${MementoSection} "Documentation" SecDoc
  SectionIn 1 2

  SetOutPath $INSTDIR\doc
;  File ..\..\doc\agena.lwp
  File ..\..\doc\agena.pdf
  File ..\..\doc\agena-crashcourse.pdf
;  File ..\..\doc\agena-crashcourse.ppt
  File ..\..\doc\agena.xls
${MementoSectionEnd}

!define AGENAPATH "$INSTDIR\lib"

${MementoSection} "Set Environment Variable AGENAPATH" SecEnv
;Section "Set Environment Variable AGENAPATH"
  SectionIn 1 2

  !ifdef ALL_USERS
    !define ReadEnvStr_RegKey \
       'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'
  !else
    !define ReadEnvStr_RegKey 'HKCU "Environment"'
  !endif

  Push AGENAPATH
  Push "${AGENAPATH}"
  ;Call WriteEnvStr
  ;StrCpy $R0 "$INSTDIR"
  StrCpy $R0 "${AGENAPATH}"
  ;messagebox mb_ok '$R0'
  System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("AGENAPATH", R0).r2'

  ReadEnvStr $R0 "PATH"
  ;messagebox mb_ok '$R0'
  ;ensure that is written valid for NT only
  ReadRegStr $0 ${ReadEnvStr_RegKey} 'AGENAPATH'
  StrCpy $R0 "$R0;$0"
  System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("PATH", R0).r2'
  ReadEnvStr $R0 "PATH"
  ;messagebox mb_ok '$R0'
  ;writeuninstaller '$EXEDIR\uninst.exe'

  ;permanently set AGENAPATH
  WriteRegExpandStr HKCU "Environment" "AGENAPATH" "${AGENAPATH}"

${MementoSectionEnd}


${MementoSection} "Append path to Agena binary to PATH" SecEnvPath
;Section "Append Agena folder to PATH"
  SectionIn 1 2

  ;append main Agena folder to PATH
  ${EnvVarUpdate} $0 "PATH" "A" "HKLM" "$INSTDIR\bin"

${MementoSectionEnd}


${MementoSection} "Desktop Shortcut" SecShortcuts

  SetDetailsPrint both
  DetailPrint "Installing Desktop Shortcut ..."
  SetDetailsPrint listonly

  SectionIn 1 2
  SetOutPath $INSTDIR

  CreateShortCut "$DESKTOP\agena.lnk" "$INSTDIR\bin\agena.exe" "" "$INSTDIR\bin\agena.ico"

${MementoSectionEnd}

SectionGroup "plus Packages" SecPluginsPlugins


${MementoSection} "mapm" SecPluginsMapm

  SetDetailsPrint both
  DetailPrint "Installing plus package mapm ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\mapm.agn
  File ..\..\lib\mapm.dll

${MementoSectionEnd}


${MementoSection} "calc" SecPluginsCalc

  SetDetailsPrint both
  DetailPrint "Installing plus package calc ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\calc.dll
  File ..\..\lib\calc.agn

${MementoSectionEnd}


${MementoSection} "linalg" SecPluginsLinalg

  SetDetailsPrint both
  DetailPrint "Installing plus package linalg ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\linalg.dll
  File ..\..\lib\linalg.agn

${MementoSectionEnd}


${MementoSection} "stats" SecPluginsStats

  SetDetailsPrint both
  DetailPrint "Installing plus package stats ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\stats.dll
  File ..\..\lib\stats.agn

${MementoSectionEnd}


${MementoSection} "div" SecPluginsDiv

  SetDetailsPrint both
  DetailPrint "Installing plus package div ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\div.agn

${MementoSectionEnd}


${MementoSection} "llist" SecPluginsLlist

  SetDetailsPrint both
  DetailPrint "Installing plus package llist ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\llist.agn
  File ..\..\lib\llist.dll

${MementoSectionEnd}


${MementoSection} "bags" SecPluginsBags

  SetDetailsPrint both
  DetailPrint "Installing plus package bags ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\bags.dll
  File ..\..\lib\bags.agn

${MementoSectionEnd}


${MementoSection} "clock" SecPluginsClock

  SetDetailsPrint both
  DetailPrint "Installing plus package clock ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\clock.agn

${MementoSectionEnd}


${MementoSection} "astro" SecPluginsAstro

  SetDetailsPrint both
  DetailPrint "Installing plus package astro ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\astro.dll
  File ..\..\lib\astro.agn

${MementoSectionEnd}


${MementoSection} "gdi" SecPluginsGdi

  SetDetailsPrint both
  DetailPrint "Installing plus package gdi ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\gdi.agn
  File ..\..\lib\gdi.dll

  SetOutPath $INSTDIR\bin
  File ..\..\ports\gdwin32\bin\freetype6.dll
  File ..\..\ports\gdwin32\bin\jpeg62.dll
  File ..\..\ports\gdwin32\bin\libiconv2.dll
  File ..\..\ports\gdwin32\bin\libpng13.dll
  File ..\..\ports\gdwin32\bin\xpm4.dll
  File ..\..\ports\gdwin32\bin\zlib1.dll
  File ..\..\ports\gdwin32\bin\libgd2.dll

${MementoSectionEnd}


${MementoSection} "fractals" SecPluginsFractals

  SetDetailsPrint both
  DetailPrint "Installing plus package fractals ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\fractals.dll
  File ..\..\lib\fractals.agn

${MementoSectionEnd}


${MementoSection} "net" SecPluginsNet

  SetDetailsPrint both
  DetailPrint "Installing plus Internet & LAN package net (IPv4) ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\net.dll
  File ..\..\lib\net.agn

${MementoSectionEnd}


${MementoSection} "xbase" SecPluginsXbase

  SetDetailsPrint both
  DetailPrint "Installing plus package xbase ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\xbase.dll
  File ..\..\lib\xbase.agn

${MementoSectionEnd}


${MementoSection} "xml" SecPluginsXml

  SetDetailsPrint both
  DetailPrint "Installing plus package xml ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\xml.dll
  File ..\..\lib\xml.agn

  SetOutPath $INSTDIR\bin
  File ..\..\ports\expat-2.1.0\.libs\libexpat-1.dll

${MementoSectionEnd}


${MementoSection} "gzip" SecPluginsGzip

  SetDetailsPrint both
  DetailPrint "Installing plus package gzip ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\gzip.agn
  File ..\..\lib\gzip.dll

${MementoSectionEnd}


${MementoSection} "skycrane" SecPluginsSkycrane

  SetDetailsPrint both
  DetailPrint "Installing plus package skycrane ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\skycrane.dll
  File ..\..\lib\skycrane.agn

${MementoSectionEnd}


${MementoSection} "ads" SecPluginsADS

  SetDetailsPrint both
  DetailPrint "Installing plus package Agena Database System ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\lib
  File ..\..\lib\ads.dll
  File ..\..\lib\ads.agn

${MementoSectionEnd}


;${MementoSectionDone}

SectionGroupEnd

SectionGroup "Misc" SecMisc

${MementoSection} "Editor scheme files" SecMiscSchemas

  SetDetailsPrint both
  DetailPrint "Installing scheme files for some editors ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\schemes
  File ..\..\schemes\nedit.rc
  File ..\..\schemes\nedit.rc.solaris
  File ..\..\schemes\agena.lang
  File ..\..\schemes\agena.sch
  File ..\..\schemes\agena.xml
  File ..\..\schemes\agena.dat
  File ..\..\schemes\readme.txt

${MementoSectionEnd}

${MementoSection} "Further icons" SecMiscIcons

  SetDetailsPrint both
  DetailPrint "Installing further icons ..."
  SetDetailsPrint listonly

  SectionIn 1

  SetOutPath $INSTDIR\share
  File ..\..\share\agena8b.ico
  File ..\..\share\agenasmall.ico
  File ..\..\share\agena64x64.ico
  File ..\..\share\agena128x128.ico

${MementoSectionEnd}


SectionGroupEnd

${MementoSectionDone}


;!include WriteEnvStr.nsh

Section -post

  SetDetailsPrint textonly
  DetailPrint "Creating Registry Keys ..."
  SetDetailsPrint listonly

  SetOutPath $INSTDIR

  ;WriteRegExpandStr HKCU "Environment" "AGENAPATH" "$INSTDIR"
  WriteRegStr HKLM "Software\Agena" "" $INSTDIR
!ifdef VER_MAJOR & VER_MINOR & VER_REVISION
  WriteRegDword HKLM "Software\Agena" "VersionMajor" "${VER_MAJOR}"
  WriteRegDword HKLM "Software\Agena" "VersionMinor" "${VER_MINOR}"
  WriteRegDword HKLM "Software\Agena" "VersionRevision" "${VER_REVISION}"
!endif

  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "InstallLocation" "$INSTDIR"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "DisplayName" "Agena"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "DisplayIcon" "$INSTDIR\bin\agena.ico,0"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "DisplayVersion" "${VERSION}"
!ifdef VER_MAJOR & VER_MINOR & VER_REVISION
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "VersionMajor" "${VER_MAJOR}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "VersionMinor" "${VER_MINOR}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "VersionRevision" "${VER_REVISION}"
!endif
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "URLInfoAbout" "${WEBSITE}/"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "HelpLink" "http://agena.sourceforge.net"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "NoModify" "1"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Agena" "NoRepair" "1"

  WriteUninstaller $INSTDIR\uninstall.exe

  ${MementoSectionSave}

  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application

    ;Create shortcuts
    CreateDirectory "$SMPROGRAMS\$StartMenuFolder"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Agena.lnk" "$INSTDIR\bin\agena.exe" "" "$INSTDIR\share\agenasmall.ico"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\AgenaEdit.lnk" "$INSTDIR\bin\agenaedit.exe" "" "$INSTDIR\share\agenasmall.ico"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Manual.lnk" "$INSTDIR\doc\agena.pdf"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Crash Course.lnk" "$INSTDIR\doc\agena-crashcourse.pdf"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Crash Course MS PowerPoint.lnk" "$INSTDIR\doc\agena-crashcourse.ppt"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Quick Reference.lnk" "$INSTDIR\doc\agena.xls"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Change Log.lnk" "$INSTDIR\bin\change.log"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Licence.lnk" "$INSTDIR\bin\licence"
    WriteINIStr "$SMPROGRAMS\$StartMenuFolder\Agena @ Sourceforge.url" "InternetShortcut" "URL" ${WEBSITE}
    ;CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Agena @ Sourceforge.lnk" "${WEBSITE}" "URL"
    CreateShortCut "$SMPROGRAMS\$StartMenuFolder\Uninstall.lnk" "$INSTDIR\uninstall.exe"

  !insertmacro MUI_STARTMENU_WRITE_END

  SetDetailsPrint both

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCore} "The core files required to use Agena (interpreter and main Agena library)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAgenaEdit} "The Agena editor and runtime environment"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDoc} "The manual, language summary, and quick reference"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecEnv} "Permanently sets the environment variable AGENAPATH to your system (recommended)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecEnvPath} "Appends the path to the Agena binary to your system PATH (recommended)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecShortcuts} "Adds Agena icon to your desktop for easy access"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsPlugins} "Additonal libraries"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsAstro} "Astronomical time and date package"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsMapm} "MAPM arbitrary precision math library"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsCalc} "Calculus package"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsStats} "Statistics package"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsLinalg} "Linear Algebra package"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsDiv} "Fraction package"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsBags} "Bags package, implementing multisets"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsClock} "Clock package, for adding, subtracting hours, minutes, and seconds"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsClock} "Bags package, implementing multisets"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsLlist} "Linked list library"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsGdi} "GDI package, for drawing graphics"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsFractals} "Fractals package"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsNet} "Network package for sending data across the Internet and LANs"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsXbase} "xBase package for reading and writing dBASE III compatible files"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsXml} "XML/LuaExpat binding for processing XML files"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsGzip} "UNIX gzip compression library"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsSkycrane} "Auxiliary Functions"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPluginsADS} "Agena Database System package, a small text data base"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMisc} "Miscellaneous"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMiscSchemas} "Editor scheme files (installs to $INSTDIR\schemes)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMiscIcons} "Further Icons (installs to $INSTDIR\share)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Installer Functions

Function .onInit
  !insertmacro MULTIUSER_INIT
  ${MementoSectionRestore}
  # the plugins dir is automatically deleted when the installer exits
  InitPluginsDir
  # Installation for all users
  SetShellVarContext all
  # Check whether installer is already running
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "myMutex") i .r1 ?e'
  Pop $R0
  StrCmp $R0 0 +3
    MessageBox MB_OK|MB_ICONEXCLAMATION "The installer is already running."
    Abort
  # Check for previous version
;  ReadRegStr $R0 HKLM \
;  "Software\Microsoft\Windows\CurrentVersion\Uninstall\AGENA" \
;  "UninstallString"
;  StrCmp $R0 "" checkdone
;  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
;  "Agena is already installed. $\n$\nClick OK to remove the previous version \
;  or Cancel to cancel this installer." \
;  IDOK uninst
;  Abort
;uninst:
;  ClearErrors
;  ExecWait '$R0 _?=$INSTDIR'  ; Do not copy the uninstaller to a temp file
;  IfErrors no_remove_uninstaller checkdone
;    ; some command here
;   no_remove_uninstaller:

;checkdone:
  # Show splash image
  File /oname=$PLUGINSDIR\splash.bmp "..\nsis\splash.bmp"
  advsplash::show 2000 600 300 -1 $PLUGINSDIR\splash
  Pop $0          ; $0 has '1' if the user closed the splash screen early,
                  ; '0' if everything closed normally, and '-1' if some error occurred.
  Delete $PLUGINSDIR\splash.bmp
FunctionEnd


Function un.onInit
 !insertmacro MULTIUSER_UNINIT
  SetShellVarContext all
FunctionEnd


!ifdef VER_MAJOR & VER_MINOR & VER_REVISION

Var ReinstallPageCheck

Function PageReinstall
  ReadRegStr $R0 HKLM "Software\Agena" ""
  ${If} $R0 == ""
    Abort
  ${EndIf}
  ReadRegDWORD $R0 HKLM "Software\Agena" "VersionMajor"
  ReadRegDWORD $R1 HKLM "Software\Agena" "VersionMinor"
  ReadRegDWORD $R2 HKLM "Software\Agena" "VersionRevision"
  StrCpy $R0 $R0.$R1.$R2
  ${VersionCompare} ${VER_MAJOR}.${VER_MINOR}.${VER_REVISION} $R0 $R0
  ${If} $R0 == 0
    StrCpy $R1 "Agena ${VERSION} is already installed. Select the operation you want to perform and click Next to continue."
    StrCpy $R2 "Add/Reinstall components"
    StrCpy $R3 "Uninstall Agena"
    !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose the maintenance option to perform."
    StrCpy $R0 "2"
  ${ElseIf} $R0 == 1
    StrCpy $R1 "An older version of Agena is installed on your system. It's recommended that you uninstall the current version before installing. Select the operation you want to perform and click Next to continue."
    StrCpy $R2 "Uninstall before installing"
    StrCpy $R3 "Do not uninstall"
    !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose how you want to install Agena."
    StrCpy $R0 "1"
  ${ElseIf} $R0 == 2
    StrCpy $R1 "A newer version of Agena is already installed! It is not recommended that you install an older version. If you really want to install this older version, it's better to uninstall the current version first. Select the operation you want to perform and click Next to continue."
    StrCpy $R2 "Uninstall before installing"
    StrCpy $R3 "Do not uninstall"
    !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose how you want to install Agena."
    StrCpy $R0 "1"
  ${Else}
    Abort
  ${EndIf}

  nsDialogs::Create /NOUNLOAD 1018
  Pop $R4
  ${NSD_CreateLabel} 0 0 100% 24u $R1
  Pop $R1
  ${NSD_CreateRadioButton} 30u 50u -30u 8u $R2
  Pop $R2
  ${NSD_OnClick} $R2 PageReinstallUpdateSelection
  ${NSD_CreateRadioButton} 30u 70u -30u 8u $R3
  Pop $R3
  ${NSD_OnClick} $R3 PageReinstallUpdateSelection
  ${If} $ReinstallPageCheck != 2
    SendMessage $R2 ${BM_SETCHECK} ${BST_CHECKED} 0
  ${Else}
    SendMessage $R3 ${BM_SETCHECK} ${BST_CHECKED} 0
  ${EndIf}
  nsDialogs::Show
FunctionEnd

Function PageReinstallUpdateSelection
  Pop $R1
  ${NSD_GetState} $R2 $R1
  ${If} $R1 == ${BST_CHECKED}
    StrCpy $ReinstallPageCheck 1
  ${Else}
    StrCpy $ReinstallPageCheck 2
  ${EndIf}
FunctionEnd

Function PageLeaveReinstall
  ${NSD_GetState} $R2 $R1
  StrCmp $R0 "1" 0 +2
  StrCmp $R1 "1" reinst_uninstall reinst_done
  StrCmp $R0 "2" 0 +3
  StrCmp $R1 "1" reinst_done reinst_uninstall

  reinst_uninstall:
  ReadRegStr $R1 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\AGENA" "UninstallString"

  ;Run uninstaller
  ; HideWindow
  ClearErrors
  ExecWait '$R1 _?=$INSTDIR'

  IfErrors no_remove_uninstaller
  IfFileExists "$INSTDIR\makensis.exe" no_remove_uninstaller

  Delete $R1
  RMDir $INSTDIR

  no_remove_uninstaller:

  StrCmp $R0 "2" 0 +2
  Quit

  BringToFront
  reinst_done:
FunctionEnd

!endif # VER_MAJOR & VER_MINOR & VER_REVISION

Function ShowReleaseNotes
  ExecShell "open" "$INSTDIR\doc\agena.pdf"
FunctionEnd

;--------------------------------
;Uninstaller Section

UninstallText "This will uninstall Agena from your computer.$\n$\nThanks for using it."
UninstallCaption "Uninstall Agena"

Section Uninstall

  SetDetailsPrint textonly
  DetailPrint "Uninstalling Agena ..."
  SetDetailsPrint listonly

  IfFileExists $INSTDIR\bin\agena.exe agena_installed
    MessageBox MB_YESNO "It does not appear that Agena is installed in the directory '$INSTDIR'.$\r$\nContinue anyway (not recommended)?" IDYES agena_installed
    Abort "Uninstall aborted by user"
  agena_installed:

  SetDetailsView show
  DetailPrint "Deleting Registry Keys ..."
  SetDetailsPrint listonly

  ReadRegStr $R0 HKCR ".nsi" ""
  StrCmp $R0 "NSIS.Script" 0 +2
  DeleteRegKey HKCR ".nsi"

  ReadRegStr $R0 HKCR ".nsh" ""
  StrCmp $R0 "NSIS.Header" 0 +2
  DeleteRegKey HKCR ".nsh"

  DeleteRegKey HKCR "NSIS.Script"
  DeleteRegKey HKCR "NSIS.Header"

  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\AGENA"
  DeleteRegKey HKLM "Software\AGENA"

  DetailPrint "Deleting Files ..."

  Delete $SMPROGRAMS\agena.lnk
  Delete $DESKTOP\agena.lnk
  RMDir /r $INSTDIR\bin
  RMDir /r $INSTDIR\doc

  Delete $INSTDIR\lib\*.agn
  Delete $INSTDIR\lib\*.dll
  Delete $INSTDIR\lib\agena.ini.sample

  ;remove lib only if it is empty
  RMDir $INSTDIR\lib
  RMDIR /r $INSTDIR\src
  RMDIR /r $INSTDIR\share
  RMDIR /r $INSTDIR\schemes
  ; Remove uninstaller
  Delete $INSTDIR\uninstall.exe
  RMDir $INSTDIR

  DeleteRegValue HKCU "Environment" "AGENAPATH"

  ;Remove Agena folder from PATH
  ${un.EnvVarUpdate} $0 "PATH" "R" "HKLM" "$INSTDIR\bin"

  !insertmacro MUI_STARTMENU_GETFOLDER Application $StartMenuFolder
  ;Delete "$SMPROGRAMS\$StartMenuFolder\Agena.lnk"
  ;Delete "$SMPROGRAMS\$StartMenuFolder\Manual.lnk"
  ;Delete "$SMPROGRAMS\$StartMenuFolder\Quick Reference.lnk"
  ;Delete "$SMPROGRAMS\$StartMenuFolder\Agena @ Sourceforge.lnk"
  ;Delete "$SMPROGRAMS\$StartMenuFolder\Uninstall.lnk"
  Delete "$SMPROGRAMS\$StartMenuFolder\*.*"
  RMDir "$SMPROGRAMS\$StartMenuFolder"

SectionEnd