#!/usr/bin/sh
# shell script for building an Agena Mac OS X PKG package on Mac OS X 10.5 Intel
# execute this script in the /installers/mac folder

# environment variables, change the following paths according to your needs

#export AGENAHOME="/Users/alexanderwalz/agena"
export AGENAHOME="../.."
export MAINTARGETDIR="$AGENAHOME/installers/mac/macinstalldir"
export AGENATARGET_USR="$MAINTARGETDIR/agena/usr"
export AGENATARGET_DOCS="$MAINTARGETDIR/agena/Library/Documentation/Agena"

#export AGENAHOME="c:/agena"
#export MAINTARGETDIR="c:/agena/installers/mac"
#export AGENATARGET_USR="$MAINTARGETDIR/agena/usr"
#export AGENATARGET_DOCS="$MAINTARGETDIR/agena/Library/Documentation/Agena"

# create directories if necessary

mkdir -p $MAINTARGETDIR
mkdir -p $MAINTARGETDIR/agena
mkdir -p $MAINTARGETDIR/agena/usr
mkdir -p $MAINTARGETDIR/agena/usr/agena
mkdir -p $MAINTARGETDIR/agena/usr/agena/lib
mkdir -p $MAINTARGETDIR/agena/usr/agena/share
mkdir -p $MAINTARGETDIR/agena/usr/agena/schemes
mkdir -p $MAINTARGETDIR/agena/usr/local
mkdir -p $MAINTARGETDIR/agena/usr/local/bin
mkdir -p $MAINTARGETDIR/agena/usr/local/lib
mkdir -p $MAINTARGETDIR/agena/usr/local/include
mkdir -p $MAINTARGETDIR/agena/usr/local/include/agena
mkdir -p $MAINTARGETDIR/agena/Library
mkdir -p $MAINTARGETDIR/agena/Library/Documentation
mkdir -p $MAINTARGETDIR/agena/Library/Documentation/Agena

# Copy files to be distributed to target folders

# Documentation files
cp $AGENAHOME/doc/agena-crashcourse.pdf $AGENATARGET_DOCS
#cp $AGENAHOME/doc/agena-crashcourse.ppt $AGENATARGET_DOCS
cp $AGENAHOME/doc/agena.pdf $AGENATARGET_DOCS
#cp $AGENAHOME/doc/Agena.lwp $AGENATARGET_DOCS
cp $AGENAHOME/doc/agena.xls $AGENATARGET_DOCS

# Library files
cp $AGENAHOME/lib/ads.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ads.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/.agenainit.sample $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ansi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bags.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bags.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.0.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/calc.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/calc.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/clock.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gdi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gdi.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gzip.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gzip.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/library.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/linalg.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/linalg.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/stats.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/stats.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fractals.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fractals.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/skycrane.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/skycrane.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xbase.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xbase.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/net.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/net.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/astro.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/astro.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xml.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xml.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/llist.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/llist.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/div.agn $AGENATARGET_USR/agena/lib

# Scheme files
cp $AGENAHOME/schemes/agena.lang $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.xml $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.dat $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.sch $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/nedit.rc $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/readme.txt $AGENATARGET_USR/agena/schemes

# Share files
cp $AGENAHOME/share/agena.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena128x128.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena128x128.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena64x64.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena64x64.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena8b.gif $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena8b.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agenasmall.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agenasmall.png $AGENATARGET_USR/agena/share

# Include files
cp $AGENAHOME/src/agnxlib.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agena.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agenalib.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agncmpt.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agnconf.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agnhlps.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agncfg.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/cephes.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/sofa.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/moon.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/sunriset.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/interp.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/m_apm.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agnt64.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agnt64_c.h $AGENATARGET_USR/local/include/agena
cp $AGENAHOME/src/agnt64_l.h $AGENATARGET_USR/local/include/agena

# Change Log
cp $AGENAHOME/change.log $AGENATARGET_USR/agena

# Binary and shared C libraries
cp $AGENAHOME/src/libagena.a $AGENATARGET_USR/local/lib
cp $AGENAHOME/src/licence $AGENATARGET_USR/local/lib
cp $AGENAHOME/src/agena $AGENATARGET_USR/local/bin
#cp $AGENAHOME/../fltk-1.1.10/editor/agenaedit $AGENATARGET_USR/local/bin
#chmod a+x $AGENATARGET_USR/local/bin/agenaedit

# position: owner & group & other
# 7 = read (1) + write (2) + execute (4) = 1 + 2 + 4 = 7
# 5 = read + execute
chmod -R 755 $AGENATARGET_USR/agena
chmod -R 755 $AGENATARGET_USR/local/include/agena
chmod 755 $AGENATARGET_USR/local/bin/agena
chmod 755 $AGENATARGET_USR/local/lib/libagena.a
