#!/usr/bin/sh
# shell script for building an AgenaZIP package on Haiku
# execute this script in the /installers/haiku folder

# environment variables, change the following paths according to your needs

export AGENAVER="1.4.0"

export AGENAHOME="/boot/apps/agena"
export MAINTARGETDIR="$AGENAHOME/installers/haiku"
export AGENATARGET_USR="$MAINTARGETDIR/agena/common/share"
export AGENATARGET_BIN="$MAINTARGETDIR/agena/common/bin"

# create directories if necessary

mkdir -p $MAINTARGETDIR
mkdir -p $MAINTARGETDIR/agena
mkdir -p $MAINTARGETDIR/agena/common
mkdir -p $MAINTARGETDIR/agena/common/bin
mkdir -p $MAINTARGETDIR/agena/common/share
mkdir -p $MAINTARGETDIR/agena/common/share/agena
mkdir -p $MAINTARGETDIR/agena/common/share/agena/doc
mkdir -p $MAINTARGETDIR/agena/common/share/agena/lib
mkdir -p $MAINTARGETDIR/agena/common/share/agena/share
mkdir -p $MAINTARGETDIR/agena/common/share/agena/schemes

# Copy files to be distributed to target folders

# Documentation files
cp $AGENAHOME/doc/agena-crashcourse.pdf $AGENATARGET_USR/agena/doc
cp $AGENAHOME/doc/agena.pdf $AGENATARGET_USR/agena/doc
cp $AGENAHOME/doc/agena.xls $AGENATARGET_USR/agena/doc

# Library files
cp $AGENAHOME/lib/ads.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ads.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/.agenainit.sample $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ansi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.0.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/calc.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/calc.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/clock.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/library.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/linalg.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/linalg.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/stats.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/stats.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xbase.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xbase.so $AGENATARGET_USR/agena/lib

# Scheme files
cp $AGENAHOME/schemes/agena.lang $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.xml $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.sch $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/nedit.rc $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/readme.txt $AGENATARGET_USR/agena/schemes

# Share files
cp $AGENAHOME/share/agena.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena128x128.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena128x128.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena8b.gif $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena8b.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agenasmall.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agenasmall.png $AGENATARGET_USR/agena/share

# Change Log
cp $AGENAHOME/src/change.log $AGENATARGET_USR/agena

# Binary and shared C libraries
cp $AGENAHOME/src/agena $AGENATARGET_BIN
cp $AGENAHOME/src/licence $AGENATARGET_USR/agena

# position: owner & group & other
# 7 = read (1) + write (2) + execute (4) = 1 + 2 + 4 = 7
# 5 = read + execute
chmod -R 755 $AGENATARGET_USR/agena
chmod 755 $AGENATARGET_BIN agena

cd agena
tar cfvz ../agena-$AGENAVER-haiku.tar.gz .
cd ..

