#!/usr/bin/sh
# shell script for building a *.deb package on Debian platforms
# execute this script in the /installers/debian folder

# environment variables, change the following paths according to your needs

export AGENAVER="2.1.0"
# CHANGE version number in control file, as well !!!

export AGENAHOME="/home/aegina/agena"
export MAINTARGETDIR="$AGENAHOME/installers/debian"
export AGENATARGET_USR="$MAINTARGETDIR/agena/usr"
export AGENATARGET_BIN="$MAINTARGETDIR/agena/usr/local/bin"
export AGENATARGET_LIB="$MAINTARGETDIR/agena/usr/local/lib"

# create directories if necessary

mkdir -p $AGENATARGET_USR/agena
mkdir -p $AGENATARGET_USR/agena/doc
mkdir -p $AGENATARGET_USR/agena/lib
mkdir -p $AGENATARGET_USR/agena/share
mkdir -p $AGENATARGET_USR/agena/schemes
mkdir -p $AGENATARGET_BIN
mkdir -p $AGENATARGET_LIB

# Copy files to be distributed to target folders

# Documentation files
cp $AGENAHOME/doc/agena-crashcourse.pdf $AGENATARGET_USR/agena/doc
cp $AGENAHOME/doc/agena.pdf $AGENATARGET_USR/agena/doc
cp $AGENAHOME/doc/agena.xls $AGENATARGET_USR/agena/doc

# Library files
cp $AGENAHOME/lib/ads.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ads.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/.agenainit.sample $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ansi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bags.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bags.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.0.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/calc.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/calc.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/clock.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gzip.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gzip.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fractals.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fractals.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gdi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gdi.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/library.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/linalg.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/linalg.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/stats.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/stats.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xbase.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xbase.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/net.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/net.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/skycrane.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/skycrane.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xml.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xml.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/astro.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/astro.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/llist.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/llist.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/div.agn $AGENATARGET_USR/agena/lib

# Scheme files
cp $AGENAHOME/schemes/agena.lang $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.xml $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.dat $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/agena.sch $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/nedit.rc $AGENATARGET_USR/agena/schemes
cp $AGENAHOME/schemes/readme.txt $AGENATARGET_USR/agena/schemes

# Share files
cp $AGENAHOME/share/agena.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena128x128.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena128x128.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena64x64.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena64x64.png $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena8b.gif $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agena8b.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agenasmall.ico $AGENATARGET_USR/agena/share
cp $AGENAHOME/share/agenasmall.png $AGENATARGET_USR/agena/share

# Change Log
cp $AGENAHOME/change.log $AGENATARGET_USR/agena

# Binary and shared C libraries
cp $AGENAHOME/src/agena $AGENATARGET_BIN
#cp $AGENAHOME/src/libagena.so $AGENATARGET_LIB
cp $AGENAHOME/src/libagena.a  $AGENATARGET_LIB
cp $AGENAHOME/../fltk-1.1.10/editor/agenaedit $AGENATARGET_BIN
cp $AGENAHOME/src/licence $AGENATARGET_USR/agena

# position: owner & group & other
# 7 = read (1) + write (2) + execute (4) = 1 + 2 + 4 = 7
# 5 = read + execute
chmod -R 755 $AGENATARGET_USR/agena
chmod 755 $AGENATARGET_BIN agena

dpkg -b agena agena-$AGENAVER-linux.ppc.deb

