/* Cephes mathematical functions

   taken from various C files written by Stephen L. Moshier.

   Cephes Math Library, Copyright by Stephen L. Moshier
   Direct inquiries to 30 Frost Street, Cambridge, MA 02140 */


#ifndef cephes_h
#define cephes_h

/* some constants */
#define EUL      0.57721566490153286061
/* #define PIO2     1.570796326794896619231E0 */
#define MACHEP   1.38777878078144567553E-17
#define MAXNUM   1.0e308
#define MAXLGM   2.556348e305
#define MAXSTIR  143.01608
#define MAXGAM   171.624376956302725
#define DP1	     3.14159265160560607910E0
#define DP2      1.98418714791870343106E-9
#define DP3	     1.14423774522196636802E-17
#define SQTPI    2.50662827463100050242E0

double polevl (double x, double coef[], int N);
double p1evl (double x, double coef[], int N);
double ei (double x);
void sici (double x, double *si, double *ci);
double chbevl (double x, double array[], int n);
void shichi (double x, double *si, double *ci);
double dawsn (double xx);
double psi (double x);
double spence (double x);
void fresnl (double xxa, double *ssa, double *cca);
double cephes_gamma (double x);


#ifndef PROPCMPLX
agn_Complex clgam (agn_Complex);
agn_Complex carctan (agn_Complex z);
agn_Complex cephes_cgamma (agn_Complex x);
#else
void clgam (double, double, double *, double *);
#endif

#endif


