/*
** $Id: agenalib.h, 2009/03/01 15:39:42 $
** $Id: lualib.h,v 1.36 2005/12/27 17:12:00 roberto Exp $
** Agena standard libraries
** See Copyright Notice in agena.h
*/


#ifndef agenalib_h
#define agenalib_h

#include "agena.h"


/* Key to file-handle type */
#define LUA_FILEHANDLE          "FILE*"


#define LUA_COLIBNAME   "coroutine"
LUALIB_API int (luaopen_base) (lua_State *L);

#define LUA_TABLIBNAME  "tables"
LUALIB_API int (luaopen_table) (lua_State *L);

#define LUA_IOLIBNAME   "io"
LUALIB_API int (luaopen_io) (lua_State *L);

#define LUA_OSLIBNAME   "os"
LUALIB_API int (luaopen_os) (lua_State *L);

#define LUA_STRLIBNAME  "strings"
LUALIB_API int (luaopen_string) (lua_State *L);

#define LUA_MATHLIBNAME "math"
LUALIB_API int (luaopen_math) (lua_State *L);

#define LUA_DBLIBNAME   "debug"
LUALIB_API int (luaopen_debug) (lua_State *L);

#define LUA_LOADLIBNAME "package"
LUALIB_API int (luaopen_package) (lua_State *L);

#define AGENA_UTILSLIBNAME "utils"
LUALIB_API int (luaopen_utils) (lua_State *L);

#define AGENA_BINIOLIBNAME "binio"
LUALIB_API int (luaopen_binio) (lua_State *L);

#define AGENA_RTABLELIBNAME "rtable"
LUALIB_API int (luaopen_rtable) (lua_State *L);

#define AGENA_ENVIRONLIBNAME "environ"
LUALIB_API int (luaopen_environ) (lua_State *L);

/* #define AGENA_FRACTLIBNAME "fractals" */
/* LUALIB_API int (luaopen_fractals) (lua_State *L); */

#if defined(LUA_DOS) || defined(__OS2__) || defined(LUA_ANSI)
/* 0.27.1: compile the following packages into the Agena excecutable */

#define AGENA_ADSLIBNAME "ads"
LUALIB_API int (luaopen_ads) (lua_State *L);

/* #define AGENA_PHQLIBNAME "phq"
LUALIB_API int (luaopen_phq) (lua_State *L); */

#define AGENA_BAGSLIBNAME "bags"
LUALIB_API int (luaopen_bags) (lua_State *L);

#define AGENA_CALCLIBNAME "calc"
LUALIB_API int (luaopen_calc) (lua_State *L);

#define AGENA_LINALGLIBNAME "linalg"
LUALIB_API int (luaopen_linalg) (lua_State *L);

#define AGENA_STATSLIBNAME "stats"
LUALIB_API int (luaopen_stats) (lua_State *L);

#define AGENA_MAPMLIBNAME "mapm"
LUALIB_API int (luaopen_mapm) (lua_State *L);

#define AGENA_XBASELIBNAME "xbase"
LUALIB_API int (luaopen_xbase) (lua_State *L);

#define AGENA_NETLIBNAME "net"
LUALIB_API int (luaopen_net) (lua_State *L);

#define AGENA_ASTROLIBNAME "astro"
LUALIB_API int (luaopen_astro) (lua_State *L);

#define AGENA_SKYCRANELIBNAME "skycrane"
LUALIB_API int (luaopen_skycrane) (lua_State *L);

#endif

#if defined(LUA_DOS)

#define AGENA_LZLIBLIBNAME "gzip"
LUALIB_API int (luaopen_gzip) (lua_State *L);

#endif

/* open all previous libraries */
LUALIB_API void (luaL_openlibs) (lua_State *L);


#ifndef lua_assert
#define lua_assert(x)   ((void)0)
#endif


#endif


