/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.ejb;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.inject.Named;
import java.lang.reflect.Type;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.ejb.Dam;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.ejb.Lake;
import org.jboss.cdi.tck.tests.extensions.beanManager.beanAttributes.ejb.LakeLocal;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Animal;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Fish;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.InvalidBeanType;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Landmark;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Natural;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.TundraStereotype;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.WaterBody;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.beanAttributes.Wild;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class CreateBeanAttributesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CreateBeanAttributesTest.class)).withClasses(new Class[]{Animal.class, Fish.class, InvalidBeanType.class, Landmark.class, Natural.class, TundraStereotype.class, WaterBody.class, Wild.class})).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bm_obtain_beanattributes", id="a")
    public void testBeanAttributesForSessionBean() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Lake.class);
        BeanAttributes attributes = this.getCurrentManager().createBeanAttributes(type);
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{LakeLocal.class, WaterBody.class, Landmark.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches(attributes.getQualifiers(), new Class[]{Natural.class, Any.class}));
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"lake");
        Assert.assertTrue((boolean)attributes.isAlternative());
    }

    @Test
    @SpecAssertion(section="bm_obtain_beanattributes", id="b")
    public void testBeanAttributesForMethod() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Dam.class);
        AnnotatedMethod lakeFishMethod = null;
        AnnotatedMethod damFishMethod = null;
        AnnotatedMethod volumeMethod = null;
        for (AnnotatedMethod method : type.getMethods()) {
            if (method.getJavaMember().getName().equals("getFish") && method.getJavaMember().getDeclaringClass().equals(Dam.class)) {
                damFishMethod = method;
            }
            if (method.getJavaMember().getName().equals("getFish") && method.getJavaMember().getDeclaringClass().equals(Lake.class)) {
                lakeFishMethod = method;
            }
            if (!method.getJavaMember().getName().equals("getVolume") || !method.getJavaMember().getDeclaringClass().equals(Lake.class)) continue;
            volumeMethod = method;
        }
        Assert.assertNotNull(lakeFishMethod);
        Assert.assertNotNull(damFishMethod);
        Assert.assertNotNull(volumeMethod);
        this.verifyLakeFish(this.getCurrentManager().createBeanAttributes(lakeFishMethod));
        this.verifyDamFish(this.getCurrentManager().createBeanAttributes(damFishMethod));
        this.verifyVolume(this.getCurrentManager().createBeanAttributes(volumeMethod));
    }

    @Test
    @SpecAssertion(section="bm_obtain_beanattributes", id="b")
    public void testBeanAttributesForField() {
        AnnotatedType type = this.getCurrentManager().createAnnotatedType(Dam.class);
        AnnotatedField lakeFishField = null;
        AnnotatedField damFishField = null;
        AnnotatedField volumeField = null;
        for (AnnotatedField field : type.getFields()) {
            if (field.getJavaMember().getName().equals("fish") && field.getJavaMember().getDeclaringClass().equals(Dam.class)) {
                damFishField = field;
            }
            if (field.getJavaMember().getName().equals("fish") && field.getJavaMember().getDeclaringClass().equals(Lake.class)) {
                lakeFishField = field;
            }
            if (!field.getJavaMember().getName().equals("volume") || !field.getJavaMember().getDeclaringClass().equals(Lake.class)) continue;
            volumeField = field;
        }
        Assert.assertNotNull(lakeFishField);
        Assert.assertNotNull(damFishField);
        Assert.assertNotNull(volumeField);
        this.verifyLakeFish(this.getCurrentManager().createBeanAttributes(lakeFishField));
        this.verifyDamFish(this.getCurrentManager().createBeanAttributes(damFishField));
        this.verifyVolume(this.getCurrentManager().createBeanAttributes(volumeField));
    }

    private void verifyLakeFish(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Fish.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{TundraStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches(attributes.getQualifiers(), new Class[]{Natural.class, Any.class, Named.class}));
        Assert.assertEquals((Object)attributes.getScope(), ApplicationScoped.class);
        Assert.assertEquals((String)attributes.getName(), (String)"fish");
        Assert.assertTrue((boolean)attributes.isAlternative());
    }

    private void verifyDamFish(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Fish.class, Animal.class, Object.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches(attributes.getQualifiers(), new Class[]{Wild.class, Any.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertNull((Object)attributes.getName());
        Assert.assertFalse((boolean)attributes.isAlternative());
    }

    private void verifyVolume(BeanAttributes<?> attributes) {
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Long.TYPE, Object.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches(attributes.getQualifiers(), new Class[]{Any.class, Default.class, Named.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
        Assert.assertEquals((Object)attributes.getScope(), Dependent.class);
        Assert.assertEquals((String)attributes.getName(), (String)"volume");
        Assert.assertFalse((boolean)attributes.isAlternative());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_obtain_beanattributes", id="c")
    public void testInvalidMember() {
        AnnotatedConstructor constructor = (AnnotatedConstructor)this.getCurrentManager().createAnnotatedType(InvalidBeanType.class).getConstructors().iterator().next();
        this.getCurrentManager().createBeanAttributes((AnnotatedMember)constructor);
    }
}

