/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.messageproducertests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.messageproducertests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    transient MessageProducer producer = null;
    transient MessageConsumer consumer = null;
    transient Connection connection = null;
    transient Session session = null;
    transient Destination destination = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            TestUtil.logMsg((String)"Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("cleanup failed!", e);
        }
    }

    public void queueSendAndRecvTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest1");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest1 failed");
        }
    }

    public void queueSendAndRecvTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest2");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, int, int, long)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 3, 0L);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest2 failed");
        }
    }

    public void queueSendAndRecvTest3() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest3");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest3", e);
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest3 failed");
        }
    }

    public void queueSendAndRecvTest4() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendAndRecvTest4");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Message, int, int, long)");
            this.producer.send((Message)expTextMessage, 1, 3, 0L);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("queueSendAndRecvTest4", e);
        }
        if (!pass) {
            throw new Exception("queueSendAndRecvTest4 failed");
        }
    }

    public void queueSetGetDeliveryModeTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            long expDeliveryMode = 2L;
            TestUtil.logMsg((String)("Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned"));
            long actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                TestUtil.logErr((String)("getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDeliveryModeTest");
        }
        try {
            int expDeliveryMode = 1;
            TestUtil.logMsg((String)("Calling setDeliveryMode(" + expDeliveryMode + ")"));
            this.producer.setDeliveryMode(expDeliveryMode);
            TestUtil.logMsg((String)("Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned"));
            int actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                TestUtil.logErr((String)("getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDeliveryModeTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDeliveryModeTest failed");
        }
    }

    public void queueSetGetDeliveryDelayTest() throws Exception {
        long actDeliveryDelay;
        long expDeliveryDelay;
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            expDeliveryDelay = 0L;
            TestUtil.logMsg((String)("Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned"));
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                TestUtil.logErr((String)("getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDeliveryDelayTest");
        }
        try {
            expDeliveryDelay = 1L;
            TestUtil.logMsg((String)("Calling setDeliveryDelay(" + expDeliveryDelay + ")"));
            this.producer.setDeliveryDelay(expDeliveryDelay);
            TestUtil.logMsg((String)("Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned"));
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                TestUtil.logErr((String)("getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDeliveryDelayTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDeliveryDelayTest failed");
        }
    }

    public void queueSetGetDisableMessageIDTest() throws Exception {
        boolean actDisableMessageID;
        boolean expDisableMessageID;
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            expDisableMessageID = true;
            TestUtil.logMsg((String)("Calling setDisableMessageID(" + expDisableMessageID + ")"));
            this.producer.setDisableMessageID(expDisableMessageID);
            TestUtil.logMsg((String)("Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned"));
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                TestUtil.logErr((String)("getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDisableMessageIDTest");
        }
        try {
            expDisableMessageID = false;
            TestUtil.logMsg((String)("Calling setDisableMessageID(" + expDisableMessageID + ")"));
            this.producer.setDisableMessageID(expDisableMessageID);
            TestUtil.logMsg((String)("Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned"));
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                TestUtil.logErr((String)("getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDisableMessageIDTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDisableMessageIDTest failed");
        }
    }

    public void queueSetGetDisableMessageTimestampTest() throws Exception {
        boolean actDisableMessageTimestamp;
        boolean expDisableMessageTimestamp;
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            expDisableMessageTimestamp = true;
            TestUtil.logMsg((String)("Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")"));
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            TestUtil.logMsg((String)("Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned"));
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                TestUtil.logErr((String)("getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDisableMessageTimestampTest");
        }
        try {
            expDisableMessageTimestamp = false;
            TestUtil.logMsg((String)("Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")"));
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            TestUtil.logMsg((String)("Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned"));
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                TestUtil.logErr((String)("getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetDisableMessageTimestampTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetDisableMessageTimestampTest failed");
        }
    }

    public void queueSetGetPriorityTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            int expPriority = 4;
            TestUtil.logMsg((String)("Calling getPriority and expect " + expPriority + " to be returned"));
            int actPriority = this.producer.getPriority();
            if (actPriority != expPriority) {
                TestUtil.logErr((String)("getPriority() returned " + actPriority + ", expected " + expPriority));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetPriorityTest");
        }
        int[] expPriority = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < expPriority.length; ++i) {
            try {
                TestUtil.logMsg((String)("Calling setPriority(" + expPriority[i] + ")"));
                this.producer.setPriority(expPriority[i]);
                TestUtil.logMsg((String)("Calling getPriority and expect " + expPriority[i] + " to be returned"));
                int actPriority = this.producer.getPriority();
                if (actPriority == expPriority[i]) continue;
                TestUtil.logErr((String)("getPriority() returned " + actPriority + ", expected " + expPriority[i]));
                pass = false;
                continue;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                throw new Exception("queueSetGetPriorityTest");
            }
        }
        if (!pass) {
            throw new Exception("queueSetGetPriorityTest failed");
        }
    }

    public void queueSetGetTimeToLiveTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = true;
            long expTimeToLive = 0L;
            TestUtil.logMsg((String)("Calling getTimeToLive and expect " + expTimeToLive + " to be returned"));
            long actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                TestUtil.logErr((String)("getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive));
                pass = false;
            }
            expTimeToLive = 1000L;
            TestUtil.logMsg((String)("Calling setTimeToLive(" + expTimeToLive + ")"));
            this.producer.setTimeToLive(expTimeToLive);
            TestUtil.logMsg((String)("Calling getTimeToLive and expect " + expTimeToLive + " to be returned"));
            actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                TestUtil.logErr((String)("getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueSetGetTimeToLiveTest");
        }
        if (!pass) {
            throw new Exception("queueSetGetTimeToLiveTest failed");
        }
    }

    public void queueInvalidDestinationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = null;
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueInvalidDestinationExceptionTests");
            try {
                TestUtil.logMsg((String)"Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logErr((String)"Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueInvalidDestinationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueInvalidDestinationExceptionTests failed");
        }
    }

    public void queueUnsupportedOperationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueUnsupportedOperationExceptionTests");
            try {
                TestUtil.logMsg((String)"Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            try {
                TestUtil.logMsg((String)"Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage, 1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueUnsupportedOperationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueUnsupportedOperationExceptionTests failed");
        }
    }

    public void queueDeliveryDelayTest() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-----------------------------------------------------------");
            TestUtil.logMsg((String)"BEGIN TEST queueDeliveryDelayTest with DeliveryDelay=30Secs");
            TestUtil.logMsg((String)"-----------------------------------------------------------");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            this.producer.setDeliveryDelay(30000L);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage message = this.session.createTextMessage("This is a test!");
            TestUtil.logMsg((String)"Set StringProperty COM_SUN_JMS_TESTNAME");
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "queueDeliveryDelayTest");
            TestUtil.logMsg((String)"Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 2, 4, 0L);
            TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                TestUtil.logErr((String)"FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Message not available after 15 seconds (CORRECT)");
                TestUtil.logMsg((String)"Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Message received after 30 seconds expired (CORRECT)");
                }
            }
            TestUtil.logMsg((String)"Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 1, 4, 0L);
            TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                TestUtil.logErr((String)"FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Message not available after 15 seconds (CORRECT)");
                TestUtil.logMsg((String)"Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Message received after 30 seconds expired (CORRECT)");
                }
            }
            TestUtil.logMsg((String)"---------------------------------------------------------");
            TestUtil.logMsg((String)"END TEST queueDeliveryDelayTest with DeliveryDelay=30Secs");
            TestUtil.logMsg((String)"---------------------------------------------------------");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("queueDeliveryDelayTest", e);
        }
        if (!pass) {
            throw new Exception("queueDeliveryDelayTest failed");
        }
    }

    public void topicSendAndRecvTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest1");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            this.consumer.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest1 failed");
        }
    }

    public void topicSendAndRecvTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest2");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, int, int, long)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 3, 0L);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest2 failed");
        }
    }

    public void topicSendAndRecvTest3() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest3");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest3", e);
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest3 failed");
        }
    }

    public void topicSendAndRecvTest4() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendAndRecvTest4");
            TestUtil.logMsg((String)"Sending TextMessage");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Message, int, int, long)");
            this.producer.send((Message)expTextMessage, 1, 3, 0L);
            TestUtil.logMsg((String)"Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 3 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("topicSendAndRecvTest4", e);
        }
        if (!pass) {
            throw new Exception("topicSendAndRecvTest4 failed");
        }
    }

    public void topicSetGetDeliveryModeTest() throws Exception {
        int actDeliveryMode;
        int expDeliveryMode;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDeliveryMode = 2;
            TestUtil.logMsg((String)("Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned"));
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                TestUtil.logErr((String)("getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDeliveryModeTest");
        }
        try {
            expDeliveryMode = 1;
            TestUtil.logMsg((String)("Calling setDeliveryMode(" + expDeliveryMode + ")"));
            this.producer.setDeliveryMode(expDeliveryMode);
            TestUtil.logMsg((String)("Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned"));
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                TestUtil.logErr((String)("getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDeliveryModeTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDeliveryModeTest failed");
        }
    }

    public void topicSetGetDeliveryDelayTest() throws Exception {
        long actDeliveryDelay;
        long expDeliveryDelay;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDeliveryDelay = 0L;
            TestUtil.logMsg((String)("Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned"));
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                TestUtil.logErr((String)("getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDeliveryDelayTest");
        }
        try {
            expDeliveryDelay = 1L;
            TestUtil.logMsg((String)("Calling setDeliveryDelay(" + expDeliveryDelay + ")"));
            this.producer.setDeliveryDelay(expDeliveryDelay);
            TestUtil.logMsg((String)("Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned"));
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                TestUtil.logErr((String)("getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDeliveryDelayTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDeliveryDelayTest failed");
        }
    }

    public void topicSetGetDisableMessageIDTest() throws Exception {
        boolean actDisableMessageID;
        boolean expDisableMessageID;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDisableMessageID = true;
            TestUtil.logMsg((String)("Calling setDisableMessageID(" + expDisableMessageID + ")"));
            this.producer.setDisableMessageID(expDisableMessageID);
            TestUtil.logMsg((String)("Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned"));
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                TestUtil.logErr((String)("getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDisableMessageIDTest");
        }
        try {
            expDisableMessageID = false;
            TestUtil.logMsg((String)("Calling setDisableMessageID(" + expDisableMessageID + ")"));
            this.producer.setDisableMessageID(expDisableMessageID);
            TestUtil.logMsg((String)("Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned"));
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                TestUtil.logErr((String)("getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDisableMessageIDTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDisableMessageIDTest failed");
        }
    }

    public void topicSetGetDisableMessageTimestampTest() throws Exception {
        boolean actDisableMessageTimestamp;
        boolean expDisableMessageTimestamp;
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            expDisableMessageTimestamp = true;
            TestUtil.logMsg((String)("Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")"));
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            TestUtil.logMsg((String)("Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned"));
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                TestUtil.logErr((String)("getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDisableMessageTimestampTest");
        }
        try {
            expDisableMessageTimestamp = false;
            TestUtil.logMsg((String)("Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")"));
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            TestUtil.logMsg((String)("Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned"));
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                TestUtil.logErr((String)("getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetDisableMessageTimestampTest");
        }
        if (!pass) {
            throw new Exception("topicSetGetDisableMessageTimestampTest failed");
        }
    }

    public void topicSetGetPriorityTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.queueTest = false;
            int expPriority = 4;
            TestUtil.logMsg((String)("Calling getPriority and expect " + expPriority + " to be returned"));
            int actPriority = this.producer.getPriority();
            if (actPriority != expPriority) {
                TestUtil.logErr((String)("getPriority() returned " + actPriority + ", expected " + expPriority));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicSetGetPriorityTest");
        }
        int[] expPriority = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < expPriority.length; ++i) {
            try {
                TestUtil.logMsg((String)("Calling setPriority(" + expPriority[i] + ")"));
                this.producer.setPriority(expPriority[i]);
                TestUtil.logMsg((String)("Calling getPriority and expect " + expPriority[i] + " to be returned"));
                int actPriority = this.producer.getPriority();
                if (actPriority == expPriority[i]) continue;
                TestUtil.logErr((String)("getPriority() returned " + actPriority + ", expected " + expPriority[i]));
                pass = false;
                continue;
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                throw new Exception("topicSetGetPriorityTest");
            }
        }
        if (!pass) {
            throw new Exception("topicSetGetPriorityTest failed");
        }
    }

    public void topicInvalidDestinationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = null;
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicInvalidDestinationExceptionTests");
            try {
                TestUtil.logMsg((String)"Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logErr((String)"Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Send message with invalid destination");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("queueInvalidDestinationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicInvalidDestinationExceptionTests failed");
        }
    }

    public void topicUnsupportedOperationExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicUnsupportedOperationExceptionTests");
            try {
                TestUtil.logMsg((String)"Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Send message with destination specified at creation time");
                this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            try {
                TestUtil.logMsg((String)"Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Send message with destination not specified at creation time");
                this.producer.send((Message)expTextMessage, 1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("topicUnsupportedOperationExceptionTests", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicUnsupportedOperationExceptionTests failed");
        }
    }

    public void topicDeliveryDelayTest() throws Exception {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"-----------------------------------------------------------");
            TestUtil.logMsg((String)"BEGIN TEST topicDeliveryDelayTest with DeliveryDelay=30Secs");
            TestUtil.logMsg((String)"-----------------------------------------------------------");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            this.producer.setDeliveryDelay(30000L);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage message = this.session.createTextMessage("This is a test!");
            TestUtil.logMsg((String)"Set StringProperty COM_SUN_JMS_TESTNAME");
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "topicDeliveryDelayTest");
            TestUtil.logMsg((String)"Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 2, 4, 0L);
            TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                TestUtil.logErr((String)"FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Message not available after 15 seconds (CORRECT)");
                TestUtil.logMsg((String)"Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Message received after 30 seconds expired (CORRECT)");
                }
            }
            TestUtil.logMsg((String)"Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=30Secs");
            this.producer.send(this.destination, (Message)message, 1, 4, 0L);
            TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
            message = (TextMessage)this.consumer.receive(15000L);
            if (message != null) {
                TestUtil.logErr((String)"FAILED: Message received before delivery delay of 30 secs elapsed");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Message not available after 15 seconds (CORRECT)");
                TestUtil.logMsg((String)"Sleeping 15 more seconds before receiving message");
                Thread.sleep(15000L);
                TestUtil.logMsg((String)"Waiting 15 seconds to receive message");
                message = (TextMessage)this.consumer.receive(15000L);
                if (message == null) {
                    TestUtil.logErr((String)"FAILED: Message was not received after delivery delay of 30 secs elapsed");
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Message received after 30 seconds expired (CORRECT)");
                }
            }
            TestUtil.logMsg((String)"---------------------------------------------------------");
            TestUtil.logMsg((String)"END TEST topicDeliveryDelayTest with DeliveryDelay=30Secs");
            TestUtil.logMsg((String)"---------------------------------------------------------");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            e.printStackTrace();
            throw new Exception("topicDeliveryDelayTest", e);
        }
        if (!pass) {
            throw new Exception("topicDeliveryDelayTest failed");
        }
    }

    public void JMSExceptionTests() throws Exception {
        boolean pass = true;
        Object tempMsg = null;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "JMSExceptionTests");
            try {
                TestUtil.logMsg((String)"Try and set an invalid priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.setPriorty(-1)");
                this.producer.setPriority(-1);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and set an invalid delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.setDeliveryMode(-1)");
                this.producer.setDeliveryMode(-1);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send((Message)expTextMessage, -1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send((Message)expTextMessage, 1, -1, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            this.cleanup();
            TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "JMSExceptionTests");
            try {
                TestUtil.logMsg((String)"Try and set an invalid priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.setPriorty(-1)");
                this.producer.setPriority(-1);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and set an invalid delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.setDeliveryMode(-1)");
                this.producer.setDeliveryMode(-1);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send((Message)expTextMessage, -1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send((Message)expTextMessage, 1, -1, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener");
                this.producer.send((Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L);
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with delivery mode of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, -1, Message.DEFAULT_PRIORITY, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
            try {
                TestUtil.logMsg((String)"Try and send message with priority of -1");
                TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, DeliveryMode.NON_PERSISTENT, -1, 0L, CompletionListener)");
                this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)new MyCompletionListener());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected JMSException, received " + e.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("JMSExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("JMSExceptionTests failed");
        }
    }

    public static class MyCompletionListener
    implements CompletionListener {
        public MyCompletionListener() {
            TestUtil.logMsg((String)"MyCompletionListener()");
        }

        public void onCompletion(Message message) {
            TestUtil.logMsg((String)"onCompletion()");
        }

        public void onException(Message message, Exception exception) {
            TestUtil.logMsg((String)"onException()");
        }
    }
}

