/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

public class ArrayTypeReference
extends LightweightTypeReference {
    private LightweightTypeReference component;

    public ArrayTypeReference(ITypeReferenceOwner owner, LightweightTypeReference component) {
        super(owner);
        this.component = (LightweightTypeReference)Preconditions.checkNotNull((Object)component, (Object)"component");
        if (component.isAny()) {
            throw new IllegalArgumentException("component is invalid: type <any> is not allowed");
        }
        if (component.isWildcard()) {
            throw new IllegalArgumentException("component is invalid: " + component);
        }
        if (!component.isOwnedBy(owner)) {
            throw new IllegalArgumentException("component is not valid in current context");
        }
    }

    @Override
    public int getKind() {
        return 3;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmGenericArrayTypeReference result = this.getTypesFactory().createJvmGenericArrayTypeReference();
        result.setComponentType(this.component.toTypeReference());
        return result;
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        return this.component.isVisible(visibilityHelper);
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        JvmGenericArrayTypeReference result = this.getTypesFactory().createJvmGenericArrayTypeReference();
        result.setComponentType(this.component.toJavaCompliantTypeReference(visibilityHelper));
        return result;
    }

    public JvmArrayType getType() {
        JvmType componentType = this.component.toJavaType().getType();
        if (componentType instanceof JvmComponentType) {
            return (JvmArrayType)Preconditions.checkNotNull((Object)((JvmComponentType)componentType).getArrayType());
        }
        if (this.component.isUnknown() || componentType.eIsProxy()) {
            return null;
        }
        throw new IllegalStateException("component type seems to be invalid: " + componentType + " / " + this.component);
    }

    @Override
    public boolean isUnknown() {
        return this.component.isUnknown();
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        List<LightweightTypeReference> componentSuperTypes = this.component.getSuperTypes(substitutor);
        ITypeReferenceOwner owner = this.getOwner();
        if (!componentSuperTypes.isEmpty()) {
            ArrayList result = Lists.newArrayListWithCapacity((int)componentSuperTypes.size());
            for (LightweightTypeReference componentSuperType : componentSuperTypes) {
                result.add(owner.newArrayTypeReference(componentSuperType));
            }
            return result;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)2);
        result.add(owner.newParameterizedTypeReference(this.findNonNullType(Cloneable.class)));
        result.add(owner.newParameterizedTypeReference(this.findNonNullType(Serializable.class)));
        return result;
    }

    @Override
    public LightweightTypeReference getSuperType(JvmType rawType) {
        if (rawType.eClass() == TypesPackage.Literals.JVM_ARRAY_TYPE) {
            JvmComponentType rawComponentType = ((JvmArrayType)rawType).getComponentType();
            LightweightTypeReference result = this.component.getSuperType((JvmType)rawComponentType);
            if (result == null) {
                return null;
            }
            if (result == this.component) {
                return this;
            }
            return this.getOwner().newArrayTypeReference(result);
        }
        if (rawType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            String identifier = rawType.getIdentifier();
            if (Object.class.getName().equals(identifier) || Cloneable.class.getName().equals(identifier) || Serializable.class.getName().equals(identifier)) {
                return this.getOwner().newParameterizedTypeReference(rawType);
            }
        }
        return null;
    }

    @Override
    public LightweightTypeReference getSuperType(Class<?> rawType) {
        if (this.isType(rawType)) {
            return this;
        }
        Class<?> rawComponentType = rawType.getComponentType();
        if (rawComponentType == null) {
            if (Object.class.equals(rawType) || Cloneable.class.equals(rawType) || Serializable.class.equals(rawType)) {
                return this.internalFindTopLevelType(rawType);
            }
            return null;
        }
        LightweightTypeReference resultComponent = this.component.getSuperType(rawComponentType);
        if (resultComponent == null) {
            return null;
        }
        return this.getOwner().newArrayTypeReference(resultComponent);
    }

    @Override
    public boolean isResolved() {
        return this.component.isResolved();
    }

    @Override
    public boolean isRawType() {
        return this.component.isRawType();
    }

    @Override
    public boolean isAnonymous() {
        return this.component.isAnonymous();
    }

    @Override
    public LightweightTypeReference getNamedType() {
        if (this.isAnonymous()) {
            return this.getOwner().newArrayTypeReference(this.component.getNamedType());
        }
        return super.getNamedType();
    }

    @Override
    public LightweightTypeReference getRawTypeReference() {
        LightweightTypeReference rawComponent = this.component.getRawTypeReference();
        if (rawComponent == this.component) {
            return this;
        }
        return this.getOwner().newArrayTypeReference(rawComponent);
    }

    @Override
    public LightweightTypeReference getConstraintSubstitute() {
        LightweightTypeReference rawComponent = this.component.getConstraintSubstitute();
        if (rawComponent == this.component) {
            return this;
        }
        return this.getOwner().newArrayTypeReference(rawComponent);
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        return super.isOwnedBy(owner) && this.component.isOwnedBy(owner);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public LightweightTypeReference tryConvertToListType() {
        ArrayTypes arrayTypes = this.getServices().getArrayTypes();
        return arrayTypes.convertToList(this);
    }

    @Override
    public ArrayTypeReference tryConvertToArray() {
        return this;
    }

    @Override
    protected LightweightTypeReference doCopyInto(ITypeReferenceOwner owner) {
        LightweightTypeReference copiedComponent = this.component.copyInto(owner);
        return owner.newArrayTypeReference(copiedComponent);
    }

    @Override
    public String getSimpleName() {
        return this.component.getSimpleName() + "[]";
    }

    @Override
    public String getIdentifier() {
        return this.component.getIdentifier() + "[]";
    }

    @Override
    public String getUniqueIdentifier() {
        return this.component.getUniqueIdentifier() + "[]";
    }

    @Override
    public String getJavaIdentifier() {
        return this.component.getJavaIdentifier() + "[]";
    }

    @Override
    public boolean isType(Class<?> clazz) {
        Class<?> clazzComponentType = clazz.getComponentType();
        if (clazzComponentType != null) {
            return this.component.isType(clazzComponentType);
        }
        return false;
    }

    @Override
    public LightweightTypeReference getComponentType() {
        return this.component;
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitArrayTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitArrayTypeReference(this, param);
    }

    @Override
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitArrayTypeReference(this);
    }

    @Override
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitArrayTypeReference(this, param);
    }
}

