/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BlendMode implements Enumerator
{
    NORMAL(0, "normal", "normal"),
    LIGHTEN(1, "lighten", "lighten"),
    MULTIPLY(2, "multiply", "multiply"),
    SCREEN(3, "screen", "screen"),
    DARKEN(4, "darken", "darken");

    public static final int NORMAL_VALUE = 0;
    public static final int LIGHTEN_VALUE = 1;
    public static final int MULTIPLY_VALUE = 2;
    public static final int SCREEN_VALUE = 3;
    public static final int DARKEN_VALUE = 4;
    private static final BlendMode[] VALUES_ARRAY;
    public static final List<BlendMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BlendMode[]{NORMAL, LIGHTEN, MULTIPLY, SCREEN, DARKEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BlendMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BlendMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BlendMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BlendMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BlendMode get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return LIGHTEN;
            }
            case 2: {
                return MULTIPLY;
            }
            case 3: {
                return SCREEN;
            }
            case 4: {
                return DARKEN;
            }
        }
        return null;
    }

    private BlendMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

