/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.utils.DirectoryCleaner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.ISubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextDirectoryCleaner
implements IGuiceAwareGeneratorComponent {
    @Inject
    private IXtextProjectConfig config;
    private boolean enabled = true;
    private boolean useDefaultExcludes = true;
    private List<String> excludes = new ArrayList<String>();
    private List<String> extraDirectories = new ArrayList<String>();

    public void addExtraDirectory(String directory) {
        this.extraDirectories.add(directory);
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void clean() {
        if (!this.enabled) {
            return;
        }
        ArrayList directories = new ArrayList();
        Iterable fsas = Iterables.concat((Iterable)Lists.transform(this.config.getEnabledProjects(), ISubProjectConfig::getSrcGen), (Iterable)Lists.newArrayList((Object[])new IXtextGeneratorFileSystemAccess[]{this.config.getRuntime().getEcoreModel()}));
        Iterables.addAll(directories, (Iterable)FluentIterable.from((Iterable)fsas).filter(Predicates.notNull()).transform(IXtextGeneratorFileSystemAccess::getPath).filter(it -> new File((String)it).isDirectory()));
        Iterables.addAll(directories, this.extraDirectories);
        DirectoryCleaner delegate = new DirectoryCleaner();
        delegate.setUseDefaultExcludes(this.useDefaultExcludes);
        this.excludes.forEach(it -> delegate.addExclude(it));
        for (String it2 : directories) {
            try {
                delegate.cleanFolder(it2);
            }
            catch (FileNotFoundException e) {
                throw Exceptions.sneakyThrow((Throwable)e);
            }
        }
    }

    @Override
    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

