/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.services.lifecycle.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.eclipse.jdt.annotation.NonNull;

public class LifecycleServiceImpl
implements ELifecycleService {
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication app;
    @Inject
    private IContributionFactory factory;

    @Override
    public void registerLifecycleURI(MUIElement element, String lifecycleURI) {
        Object object;
        HashMap<@NonNull String, @NonNull Object> contributions = (HashMap<String, Object>)element.getTransientData().get("EFX_LIFECYCLE");
        if (contributions == null) {
            contributions = new HashMap<String, Object>();
            element.getTransientData().put("EFX_LIFECYCLE", contributions);
        }
        if (!contributions.containsKey(lifecycleURI) && (object = this.factory.create(lifecycleURI, this.app.getContext())) != null) {
            contributions.put(lifecycleURI, object);
        }
    }

    @Override
    public boolean validateAnnotation(Class<? extends Annotation> annotationClass, MUIElement element, IEclipseContext context) {
        return LifecycleServiceImpl.validateLifecycleAnnotation(annotationClass, this.getContextForParent(element), context, element);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean validateLifecycleAnnotation(Class<? extends Annotation> clazz, IEclipseContext parentContext, IEclipseContext partContext, MUIElement part) {
        boolean res;
        Object invokeResult;
        MContribution c;
        if (part instanceof MContribution && (c = (MContribution)part).getObject() != null && (invokeResult = ContextInjectionFactory.invoke((Object)c.getObject(), clazz, (IEclipseContext)parentContext, (IEclipseContext)partContext, (Object)Boolean.TRUE)) != null && invokeResult instanceof Boolean && !(res = ((Boolean)invokeResult).booleanValue())) {
            return false;
        }
        @NonNull @NonNull Map contributions = (Map)part.getTransientData().get("EFX_LIFECYCLE");
        if (contributions != null) {
            for (Object object : contributions.values()) {
                boolean res2;
                Object invokeResult2 = ContextInjectionFactory.invoke(object, clazz, (IEclipseContext)parentContext, (IEclipseContext)partContext, (Object)Boolean.TRUE);
                if (invokeResult2 == null || !(invokeResult2 instanceof Boolean) || (res2 = ((Boolean)invokeResult2).booleanValue())) continue;
                return false;
            }
        }
        return true;
    }

    private IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void unregisterLifecycleContribution(MUIElement element, Object contribution) {
        @NonNull Set objects = (Set)element.getTransientData().get("EFX_LIFECYCLE");
        if (objects != null) {
            objects.remove(contribution);
        }
    }
}

