/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import java.util.WeakHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.fx.ui.panes.AbstractLayoutPane;
import org.eclipse.fx.ui.panes.RowData;

public class RowLayoutPane
extends AbstractLayoutPane<RowData> {
    public ObjectProperty<Type> type = new SimpleObjectProperty((Object)this, "type", (Object)Type.HORIZONTAL);
    public IntegerProperty marginWidth = new SimpleIntegerProperty((Object)this, "marginWidth", 0);
    public IntegerProperty marginHeight = new SimpleIntegerProperty((Object)this, "marginHeight", 0);
    public IntegerProperty spacing = new SimpleIntegerProperty((Object)this, "spacing", 3);
    public BooleanProperty wrap = new SimpleBooleanProperty((Object)this, "wrap", true);
    public BooleanProperty pack = new SimpleBooleanProperty((Object)this, "pack", true);
    public BooleanProperty fill = new SimpleBooleanProperty((Object)this, "fill", false);
    public BooleanProperty center = new SimpleBooleanProperty((Object)this, "center", false);
    public BooleanProperty justify = new SimpleBooleanProperty((Object)this, "justify", false);
    public IntegerProperty marginLeft = new SimpleIntegerProperty((Object)this, "marginLeft", 3);
    public IntegerProperty marginTop = new SimpleIntegerProperty((Object)this, "marginTop", 3);
    public IntegerProperty marginRight = new SimpleIntegerProperty((Object)this, "marginRight", 3);
    public IntegerProperty marginBottom = new SimpleIntegerProperty((Object)this, "marginBottom", 3);
    private static WeakHashMap<Node, RowData> CONSTRAINTS = new WeakHashMap();

    public static void setConstraint(Node n, RowData griddata) {
        CONSTRAINTS.put(n, griddata);
    }

    public static RowData getConstraint(Node n) {
        return CONSTRAINTS.get(n);
    }

    @Override
    protected AbstractLayoutPane.Size computeSize(double wHint, double hHint, boolean flushCache) {
        AbstractLayoutPane.Size extent = this.type.get() == Type.HORIZONTAL ? this.layoutHorizontal(false, wHint != -1.0 && this.wrap.get(), wHint, flushCache) : this.layoutVertical(false, hHint != -1.0 && this.wrap.get(), hHint, flushCache);
        double width = extent.width;
        double height = extent.height;
        if (wHint != -1.0) {
            width = wHint;
        }
        if (hHint != -1.0) {
            height = hHint;
        }
        return new AbstractLayoutPane.Size(width, height);
    }

    AbstractLayoutPane.Size computeSize(Node control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        RowData data = RowLayoutPane.getConstraint(control);
        if (data != null) {
            wHint = data.width.get();
            hHint = data.height.get();
        }
        return new AbstractLayoutPane.Size(control.prefWidth((double)wHint), control.prefHeight((double)hHint));
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Bounds clientArea = this.getLayoutBounds();
        if (this.type.get() == Type.HORIZONTAL) {
            this.layoutHorizontal(true, this.wrap.get(), clientArea.getWidth(), true);
        } else {
            this.layoutVertical(true, this.wrap.get(), clientArea.getHeight(), true);
        }
    }

    AbstractLayoutPane.Size layoutHorizontal(boolean move, boolean wrap, double width, boolean flushCache) {
        Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = 0;
        int i = 0;
        while (i < children.length) {
            Node control = children[i];
            RowData data = RowLayoutPane.getConstraint(control);
            if (data == null || !data.exclude.get()) {
                children[count++] = children[i];
            }
            ++i;
        }
        if (count == 0) {
            return new AbstractLayoutPane.Size(this.marginLeft.get() + this.marginWidth.get() * 2 + this.marginRight.get(), this.marginTop.get() + this.marginHeight.get() * 2 + this.marginBottom.get());
        }
        double childWidth = 0.0;
        double childHeight = 0.0;
        double maxHeight = 0.0;
        if (!this.pack.get()) {
            int i2 = 0;
            while (i2 < count) {
                Node child = children[i2];
                AbstractLayoutPane.Size size = this.computeSize(child, flushCache);
                childWidth = Math.max(childWidth, size.width);
                childHeight = Math.max(childHeight, size.height);
                ++i2;
            }
            maxHeight = childHeight;
        }
        double clientX = 0.0;
        double clientY = 0.0;
        if (move) {
            Bounds rect = this.getLayoutBounds();
            clientX = rect.getMinX();
            clientY = rect.getMinY();
        }
        double[] wraps = null;
        boolean wrapped = false;
        Bounds[] bounds = null;
        if (move && (this.justify.get() || this.fill.get() || this.center.get())) {
            bounds = new Bounds[count];
            wraps = new double[count];
        }
        double maxX = 0.0;
        double x = this.marginLeft.get() + this.marginWidth.get();
        double y = this.marginTop.get() + this.marginHeight.get();
        int i3 = 0;
        while (i3 < count) {
            Node child = children[i3];
            if (this.pack.get()) {
                AbstractLayoutPane.Size size = this.computeSize(child, flushCache);
                childWidth = size.width;
                childHeight = size.height;
            }
            if (wrap && i3 != 0 && x + childWidth > width) {
                wrapped = true;
                if (move && (this.justify.get() || this.fill.get() || this.center.get()) && wraps != null) {
                    wraps[i3 - 1] = maxHeight;
                }
                x = this.marginLeft.get() + this.marginWidth.get();
                y += (double)this.spacing.get() + maxHeight;
                if (this.pack.get()) {
                    maxHeight = 0.0;
                }
            }
            if (this.pack.get() || this.fill.get() || this.center.get()) {
                maxHeight = Math.max(maxHeight, childHeight);
            }
            if (move) {
                double childX = x + clientX;
                double childY = y + clientY;
                if (this.justify.get() || this.fill.get() || this.center.get()) {
                    if (bounds != null) {
                        bounds[i3] = new BoundingBox(childX, childY, childWidth, childHeight);
                    }
                } else {
                    child.resizeRelocate(childX, childY, childWidth, childHeight);
                }
            }
            maxX = Math.max(maxX, x += (double)this.spacing.get() + childWidth);
            ++i3;
        }
        maxX = Math.max(clientX + (double)this.marginLeft.get() + (double)this.marginWidth.get(), maxX - (double)this.spacing.get());
        if (!wrapped) {
            maxX += (double)(this.marginRight.get() + this.marginWidth.get());
        }
        if (move && (this.justify.get() || this.fill.get() || this.center.get())) {
            double space = 0.0;
            double margin = 0.0;
            if (!wrapped) {
                space = Math.max(0.0, (width - maxX) / (double)(count + 1));
                margin = Math.max(0.0, (width - maxX) % (double)(count + 1) / 2.0);
            } else if (this.fill.get() || this.justify.get() || this.center.get()) {
                int last = 0;
                if (count > 0 && wraps != null) {
                    wraps[count - 1] = maxHeight;
                }
                int i4 = 0;
                while (i4 < count) {
                    if (wraps != null && wraps[i4] != 0.0) {
                        int wrapCount = i4 - last + 1;
                        if (this.justify.get()) {
                            int wrapX = 0;
                            int j = last;
                            while (j <= i4) {
                                if (bounds != null) {
                                    wrapX = (int)((double)wrapX + (bounds[j].getWidth() + (double)this.spacing.get()));
                                }
                                ++j;
                            }
                            space = Math.max(0.0, (width - (double)wrapX) / (double)(wrapCount + 1));
                            margin = Math.max(0.0, (width - (double)wrapX) % (double)(wrapCount + 1) / 2.0);
                        }
                        int j = last;
                        while (j <= i4) {
                            if (this.justify.get() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeX(bounds[j], space * (double)(j - last + 1) + margin);
                            }
                            if (this.fill.get()) {
                                if (bounds != null) {
                                    bounds[j] = RowLayoutPane.changeHeight(bounds[j], wraps[i4]);
                                }
                            } else if (this.center.get() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeY(bounds[j], Math.max(0.0, (wraps[i4] - bounds[j].getHeight()) / 2.0));
                            }
                            ++j;
                        }
                        last = i4 + 1;
                    }
                    ++i4;
                }
            }
            int i5 = 0;
            while (i5 < count) {
                if (!wrapped) {
                    if (this.justify.get() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeX(bounds[i5], space * (double)(i5 + 1) + margin);
                    }
                    if (this.fill.get()) {
                        if (bounds != null) {
                            bounds[i5] = RowLayoutPane.changeHeight(bounds[i5], maxHeight);
                        }
                    } else if (this.center.get() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeY(bounds[i5], Math.max(0.0, (maxHeight - bounds[i5].getHeight()) / 2.0));
                    }
                }
                if (bounds != null) {
                    children[i5].resizeRelocate(bounds[i5].getMinX(), bounds[i5].getMinY(), bounds[i5].getWidth(), bounds[i5].getHeight());
                }
                ++i5;
            }
        }
        return new AbstractLayoutPane.Size(maxX, y + maxHeight + (double)this.marginBottom.get() + (double)this.marginHeight.get());
    }

    AbstractLayoutPane.Size layoutVertical(boolean move, boolean wrap, double height, boolean flushCache) {
        Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = 0;
        int i = 0;
        while (i < children.length) {
            Node control = children[i];
            RowData data = RowLayoutPane.getConstraint(control);
            if (data == null || !data.exclude.get()) {
                children[count++] = children[i];
            }
            ++i;
        }
        if (count == 0) {
            return new AbstractLayoutPane.Size(this.marginLeft.get() + this.marginWidth.get() * 2 + this.marginRight.get(), this.marginTop.get() + this.marginHeight.get() * 2 + this.marginBottom.get());
        }
        double childWidth = 0.0;
        double childHeight = 0.0;
        double maxWidth = 0.0;
        if (!this.pack.get()) {
            int i2 = 0;
            while (i2 < count) {
                Node child = children[i2];
                AbstractLayoutPane.Size size = this.computeSize(child, flushCache);
                childWidth = Math.max(childWidth, size.width);
                childHeight = Math.max(childHeight, size.height);
                ++i2;
            }
            maxWidth = childWidth;
        }
        double clientX = 0.0;
        double clientY = 0.0;
        if (move) {
            Bounds rect = this.getLayoutBounds();
            clientX = rect.getMinX();
            clientY = rect.getMinY();
        }
        double[] wraps = null;
        boolean wrapped = false;
        Bounds[] bounds = null;
        if (move && (this.justify.get() || this.fill.get() || this.center.get())) {
            bounds = new Bounds[count];
            wraps = new double[count];
        }
        double maxY = 0.0;
        double x = this.marginLeft.get() + this.marginWidth.get();
        double y = this.marginTop.get() + this.marginHeight.get();
        int i3 = 0;
        while (i3 < count) {
            Node child = children[i3];
            if (this.pack.get()) {
                AbstractLayoutPane.Size size = this.computeSize(child, flushCache);
                childWidth = size.width;
                childHeight = size.height;
            }
            if (wrap && i3 != 0 && y + childHeight > height) {
                wrapped = true;
                if (move && (this.justify.get() || this.fill.get() || this.center.get()) && wraps != null) {
                    wraps[i3 - 1] = maxWidth;
                }
                x += (double)this.spacing.get() + maxWidth;
                y = this.marginTop.get() + this.marginHeight.get();
                if (this.pack.get()) {
                    maxWidth = 0.0;
                }
            }
            if (this.pack.get() || this.fill.get() || this.center.get()) {
                maxWidth = Math.max(maxWidth, childWidth);
            }
            if (move) {
                double childX = x + clientX;
                double childY = y + clientY;
                if (this.justify.get() || this.fill.get() || this.center.get()) {
                    if (bounds != null) {
                        bounds[i3] = new BoundingBox(childX, childY, childWidth, childHeight);
                    }
                } else {
                    child.resizeRelocate(childX, childY, childWidth, childHeight);
                }
            }
            maxY = Math.max(maxY, y += (double)this.spacing.get() + childHeight);
            ++i3;
        }
        maxY = Math.max(clientY + (double)this.marginTop.get() + (double)this.marginHeight.get(), maxY - (double)this.spacing.get());
        if (!wrapped) {
            maxY += (double)(this.marginBottom.get() + this.marginHeight.get());
        }
        if (move && (this.justify.get() || this.fill.get() || this.center.get())) {
            double space = 0.0;
            double margin = 0.0;
            if (!wrapped) {
                space = Math.max(0.0, (height - maxY) / (double)(count + 1));
                margin = Math.max(0.0, (height - maxY) % (double)(count + 1) / 2.0);
            } else if (this.fill.get() || this.justify.get() || this.center.get()) {
                int last = 0;
                if (count > 0 && wraps != null) {
                    wraps[count - 1] = maxWidth;
                }
                int i4 = 0;
                while (i4 < count) {
                    if (wraps != null && wraps[i4] != 0.0) {
                        int wrapCount = i4 - last + 1;
                        if (this.justify.get()) {
                            int wrapY = 0;
                            int j = last;
                            while (j <= i4) {
                                if (bounds != null) {
                                    wrapY = (int)((double)wrapY + (bounds[j].getHeight() + (double)this.spacing.get()));
                                }
                                ++j;
                            }
                            space = Math.max(0.0, (height - (double)wrapY) / (double)(wrapCount + 1));
                            margin = Math.max(0.0, (height - (double)wrapY) % (double)(wrapCount + 1) / 2.0);
                        }
                        int j = last;
                        while (j <= i4) {
                            if (this.justify.get() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeY(bounds[j], space * (double)(j - last + 1) + margin);
                            }
                            if (this.fill.get()) {
                                if (bounds != null) {
                                    bounds[j] = RowLayoutPane.changeWidth(bounds[j], wraps[i4]);
                                }
                            } else if (this.center.get() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeX(bounds[j], Math.max(0.0, (wraps[i4] - bounds[j].getWidth()) / 2.0));
                            }
                            ++j;
                        }
                        last = i4 + 1;
                    }
                    ++i4;
                }
            }
            int i5 = 0;
            while (i5 < count) {
                if (!wrapped) {
                    if (this.justify.get() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeY(bounds[i5], space * (double)(i5 + 1) + margin);
                    }
                    if (this.fill.get()) {
                        if (bounds != null) {
                            bounds[i5] = RowLayoutPane.changeWidth(bounds[i5], maxWidth);
                        }
                    } else if (this.center.get() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeX(bounds[i5], Math.max(0.0, (maxWidth - bounds[i5].getWidth()) / 2.0));
                    }
                }
                if (bounds != null) {
                    children[i5].resizeRelocate(bounds[i5].getMinX(), bounds[i5].getMinY(), bounds[i5].getWidth(), bounds[i5].getHeight());
                }
                ++i5;
            }
        }
        return new AbstractLayoutPane.Size(x + maxWidth + (double)this.marginRight.get() + (double)this.marginWidth.get(), maxY);
    }

    private static Bounds changeX(Bounds original, double amount) {
        return new BoundingBox(original.getMinX() + amount, original.getMinY(), original.getWidth(), original.getHeight());
    }

    private static Bounds changeY(Bounds original, double amount) {
        return new BoundingBox(original.getMinX(), original.getMinY() + amount, original.getWidth(), original.getHeight());
    }

    private static Bounds changeHeight(Bounds original, double amount) {
        return new BoundingBox(original.getMinX(), original.getMinY(), original.getWidth(), original.getHeight() + amount);
    }

    private static Bounds changeWidth(Bounds original, double amount) {
        return new BoundingBox(original.getMinX(), original.getMinY(), original.getWidth() + amount, original.getHeight());
    }

    public void setCenterHint(boolean value) {
        this.center.set(value);
    }

    public boolean isCenterHint() {
        return this.center.get();
    }

    public BooleanProperty centerProperty() {
        return this.center;
    }

    public void setFill(boolean value) {
        this.fill.set(value);
    }

    public boolean isFill() {
        return this.fill.get();
    }

    public BooleanProperty fillProperty() {
        return this.fill;
    }

    public void setJustify(boolean value) {
        this.justify.set(value);
    }

    public boolean isJustify() {
        return this.justify.get();
    }

    public BooleanProperty justifyProperty() {
        return this.justify;
    }

    public void setMarginBottom(int value) {
        this.marginBottom.set(value);
    }

    public int getMarginBottom() {
        return this.marginBottom.get();
    }

    public IntegerProperty marginBottomProperty() {
        return this.marginBottom;
    }

    public void setMarginHeight(int value) {
        this.marginHeight.set(value);
    }

    public int getMarginHeight() {
        return this.marginHeight.get();
    }

    public IntegerProperty marginHeightProperty() {
        return this.marginHeight;
    }

    public void setMarginLeft(int value) {
        this.marginLeft.set(value);
    }

    public int getMarginLeft() {
        return this.marginLeft.get();
    }

    public IntegerProperty marginLeftProperty() {
        return this.marginLeft;
    }

    public void setMarginRight(int value) {
        this.marginRight.set(value);
    }

    public int getMarginRight() {
        return this.marginRight.get();
    }

    public IntegerProperty marginRightProperty() {
        return this.marginRight;
    }

    public void setMarginTop(int value) {
        this.marginTop.set(value);
    }

    public int getMarginTop() {
        return this.marginTop.get();
    }

    public IntegerProperty marginTopProperty() {
        return this.marginTop;
    }

    public void setMarginWidth(int value) {
        this.marginWidth.set(value);
    }

    public int getMarginWidth() {
        return this.marginWidth.get();
    }

    public IntegerProperty marginWidthProperty() {
        return this.marginWidth;
    }

    public void setPack(boolean value) {
        this.pack.set(value);
    }

    public boolean isPack() {
        return this.pack.get();
    }

    public BooleanProperty packProperty() {
        return this.pack;
    }

    public void setSpacing(int value) {
        this.spacing.set(value);
    }

    public int getSpacing() {
        return this.spacing.get();
    }

    public IntegerProperty spacingProperty() {
        return this.spacing;
    }

    public void setWrap(boolean value) {
        this.wrap.set(value);
    }

    public boolean isWrap() {
        return this.wrap.get();
    }

    public BooleanProperty wrapProperty() {
        return this.wrap;
    }

    public void setType(Type value) {
        this.type.set((Object)value);
    }

    public Type getType() {
        return (Type)((Object)this.type.get());
    }

    public ObjectProperty<Type> typeProperty() {
        return this.type;
    }

    public static enum Type {
        VERTICAL,
        HORIZONTAL;

    }
}

