/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.lifecycle.ELifecycleService;
import org.eclipse.fx.ui.lifecycle.annotations.PreClose;
import org.eclipse.fx.ui.workbench.base.rendering.AbstractRenderer;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPlaceholderWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseStackRenderer<N, I, IC>
extends BaseRenderer<MPartStack, WStack<N, I, IC>> {
    @Inject
    RendererFactory factory;
    @Inject
    MApplication application;
    @Inject
    ELifecycleService lifecycleService;
    boolean inLazyInit;

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MPartStack parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartStack && BaseStackRenderer.this == (parent = (MPartStack)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BaseStackRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BaseStackRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MPartStack parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartStack && BaseStackRenderer.this == (parent = (MPartStack)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BaseStackRenderer.this.handleSelectedElement(parent, (MStackElement)oldValue, (MStackElement)newValue);
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", new EventHandler(){

            public void handleEvent(Event event) {
                MElementContainer parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered() && (parent = changedObj.getParent()) != null && BaseStackRenderer.this == parent.getRenderer()) {
                    MPartStack stack = (MPartStack)parent;
                    String eventType = (String)event.getProperty("EventType");
                    if ("SET".equals(eventType)) {
                        Boolean newValue = (Boolean)event.getProperty("NewValue");
                        if (newValue.booleanValue()) {
                            BaseStackRenderer.this.childRendered(stack, changedObj);
                        } else {
                            BaseStackRenderer.this.hideChild(stack, changedObj);
                        }
                    }
                }
            }
        });
    }

    MPart getPart(MUIElement element) {
        if (element instanceof MPlaceholder) {
            return (MPart)((MPlaceholder)element).getRef();
        }
        if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            if ((element = container.getSelectedElement()) == null && !container.getChildren().isEmpty()) {
                element = (MUIElement)container.getChildren().get(0);
            }
            return this.getPart(element);
        }
        return (MPart)element;
    }

    @Override
    protected void initWidget(final MPartStack element, WStack<N, I, IC> widget) {
        super.initWidget(element, widget);
        widget.setMouseSelectedItemCallback(new WCallback<WStack.WStackItem<I, IC>, Void>(){

            @Override
            public Void call(WStack.WStackItem<I, IC> param) {
                if (param.getDomElement() != null) {
                    BaseStackRenderer.this.activatationJob(element, BaseStackRenderer.this.getPart((MUIElement)param.getDomElement()), true);
                }
                return null;
            }
        });
        widget.setKeySelectedItemCallback(new WCallback<WStack.WStackItem<I, IC>, Void>(){

            @Override
            public Void call(WStack.WStackItem<I, IC> param) {
                if (param.getDomElement() != null) {
                    BaseStackRenderer.this.activatationJob(element, BaseStackRenderer.this.getPart((MUIElement)param.getDomElement()), false);
                }
                return null;
            }
        });
        widget.registerActivationCallback(new WCallback<Boolean, Void>(){

            @Override
            public Void call(Boolean param) {
                if (param.booleanValue() && element.getSelectedElement() != null) {
                    BaseStackRenderer.this.activatationJob(element, BaseStackRenderer.this.getPart(element.getSelectedElement()), true);
                }
                return null;
            }
        });
    }

    private void activatationJob(MPartStack stackToActivate, MPart p, boolean focus) {
        if (this.shouldActivate(stackToActivate)) {
            this.activate(p, focus);
        }
    }

    private boolean shouldActivate(MPartStack stackToActivate) {
        IEclipseContext applicationContext;
        IEclipseContext activeChild;
        if (this.inContentProcessing((MUIElement)stackToActivate)) {
            return false;
        }
        return this.application == null || (activeChild = (applicationContext = this.application.getContext()).getActiveChild()) != null && activeChild.get(MWindow.class) == this.application.getSelectedElement() && this.application.getSelectedElement() == this.modelService.getTopLevelWindowFor((MUIElement)stackToActivate);
    }

    @Override
    public void doProcessContent(MPartStack element) {
        WStack stack = (WStack)this.getWidget((MUIElement)element);
        ArrayList items = new ArrayList();
        WStack.WStackItem<I, IC> initalItem = null;
        for (MStackElement e : element.getChildren()) {
            AbstractRenderer renderer = this.factory.getRenderer((MUIElement)e);
            if (renderer == null || !e.isToBeRendered() || !e.isVisible()) continue;
            WStack.WStackItem<I, IC> item = this.createStackItem(stack, e, renderer);
            items.add(item);
            if (e != element.getSelectedElement()) continue;
            initalItem = item;
        }
        if (!items.isEmpty()) {
            if (initalItem == null || items.size() == 1 || items.get(0) == initalItem) {
                stack.addItems(items);
            } else {
                stack.addItem(initalItem);
                if (items.get(items.size() - 1) == initalItem) {
                    stack.addItems(0, items.subList(0, items.size() - 1));
                } else {
                    int idx = items.indexOf(initalItem);
                    stack.addItems(0, items.subList(0, idx));
                    stack.addItems(items.subList(idx + 1, items.size()));
                }
            }
        }
        stack.selectItem(stack.getItems().indexOf(initalItem));
    }

    private WStack.WStackItem<I, IC> createStackItem(WStack<N, I, IC> stack, final MStackElement e, AbstractRenderer<MStackElement, ?> renderer) {
        IEclipseContext context = renderer.setupRenderingContext((MUIElement)e);
        WStack.WStackItem item = (WStack.WStackItem)ContextInjectionFactory.make(stack.getStackItemClass(), (IEclipseContext)context);
        item.setDomElement(e);
        item.setInitCallback(new WCallback<WStack.WStackItem<I, IC>, IC>(){

            @Override
            public IC call(WStack.WStackItem<I, IC> param) {
                BaseStackRenderer.this.inLazyInit = true;
                try {
                    WLayoutedWidget widget = (WLayoutedWidget)BaseStackRenderer.this.engineCreateWidget(e);
                    if (widget != null) {
                        Object object = widget.getStaticLayoutNode();
                        return object;
                    }
                    return null;
                }
                finally {
                    BaseStackRenderer.this.inLazyInit = false;
                }
            }
        });
        item.setOnCloseCallback(new WCallback<WStack.WStackItem<I, IC>, Boolean>(){

            @Override
            public Boolean call(WStack.WStackItem<I, IC> param) {
                return !BaseStackRenderer.this.handleStackItemClose(e, param);
            }
        });
        return item;
    }

    void handleChildrenAddition(MPartStack parent, Collection<MStackElement> elements) {
        for (MStackElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            int idx = this.getRenderedIndex((MUIElement)parent, (MUIElement)element);
            AbstractRenderer renderer = this.factory.getRenderer((MUIElement)element);
            WStack stack = (WStack)this.getWidget((MUIElement)parent);
            WStack.WStackItem<I, IC> item = this.createStackItem((WStack)this.getWidget((MUIElement)parent), element, renderer);
            stack.addItems(idx, Collections.singletonList(item));
        }
    }

    void handleChildrenRemove(MPartStack parent, Collection<MStackElement> elements) {
        ArrayList<MStackElement> list = new ArrayList<MStackElement>(elements);
        MStackElement selectedElement = (MStackElement)parent.getSelectedElement();
        if (selectedElement != null && list.contains(selectedElement)) {
            list.remove(selectedElement);
            list.add(selectedElement);
        }
        WStack parentWidget = (WStack)this.getWidget((MUIElement)parent);
        List<WStack.WStackItem<I, IC>> items = this.transmuteList(parentWidget, list);
        parentWidget.removeItems(items);
        ArrayList<MStackElement> removeOnHideList = new ArrayList<MStackElement>();
        for (MStackElement element : list) {
            if (!element.getTags().contains("removeOnHide")) continue;
            removeOnHideList.add(element);
        }
        parent.getChildren().removeAll(removeOnHideList);
    }

    private List<WStack.WStackItem<I, IC>> transmuteList(WStack<N, I, IC> parentWidget, ArrayList<MStackElement> list) {
        ArrayList<WStack.WStackItem<I, IC>> resultList = new ArrayList<WStack.WStackItem<I, IC>>();
        for (WStack.WStackItem<I, IC> item : parentWidget.getItems()) {
            MStackElement domElement = item.getDomElement();
            if (!list.contains(domElement) || !domElement.isToBeRendered() || !domElement.isVisible()) continue;
            resultList.add(item);
        }
        return resultList;
    }

    void handleSelectedElement(MPartStack parent, MStackElement oldElement, MStackElement newElement) {
        WStack stack = (WStack)this.getWidget((MUIElement)parent);
        int idx = 0;
        for (WStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() == newElement) {
                stack.selectItem(idx);
                this.showElementRecursive((MUIElement)newElement);
                return;
            }
            ++idx;
        }
        this.childRendered(parent, (MUIElement)newElement);
        stack.selectItem(parent.getChildren().indexOf(newElement));
        this.showElementRecursive((MUIElement)newElement);
    }

    boolean handleStackItemClose(MStackElement e, WStack.WStackItem<I, IC> item) {
        MPart part = this.getPart((MUIElement)e);
        if (!part.isCloseable()) {
            return false;
        }
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = this.getContextForParent((MUIElement)part);
        IEclipseContext context = (partContext == null ? parentContext : partContext).createChild();
        if (partContext == null) {
            context.set(MPart.class, (Object)part);
        }
        EPartService partService = (EPartService)context.get(EPartService.class.getName());
        try {
            if (partService.savePart(part, true) && this.lifecycleService.validateAnnotation(PreClose.class, (MUIElement)part, context)) {
                partService.hidePart(part);
                return true;
            }
            return false;
        }
        finally {
            context.dispose();
        }
    }

    public void childRendered(MPartStack parentElement, MUIElement element) {
        if (element == null || this.inLazyInit || this.inContentProcessing((MUIElement)parentElement) || !element.isVisible()) {
            return;
        }
        WStack stack = (WStack)this.getWidget((MUIElement)parentElement);
        for (WStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() != element) continue;
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        AbstractRenderer renderer = this.factory.getRenderer(element);
        stack.addItems(idx, Collections.singletonList(this.createStackItem(stack, (MStackElement)element, renderer)));
    }

    public void hideChild(MPartStack container, MUIElement changedObj) {
        WStack stack = (WStack)this.getWidget((MUIElement)container);
        if (stack == null) {
            return;
        }
        WStack.WStackItem item = null;
        for (WStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() != changedObj) continue;
            item = i;
            break;
        }
        if (item != null) {
            List<Object> l = Collections.singletonList(item);
            stack.removeItems(l);
        }
        if (changedObj.getTags().contains("removeOnHide")) {
            container.getChildren().remove(changedObj);
        }
    }

    private void showElementRecursive(MUIElement element) {
        IEclipseContext context;
        if (element == null || !element.isToBeRendered()) {
            return;
        }
        if (element instanceof MPlaceholder && element.getWidget() != null) {
            MPlaceholder ph = (MPlaceholder)element;
            MUIElement ref = ph.getRef();
            if (ref.getCurSharedRef() != ph) {
                ref.setCurSharedRef(ph);
                WPlaceholderWidget placeholder = (WPlaceholderWidget)ph.getWidget();
                WLayoutedWidget content = (WLayoutedWidget)ref.getWidget();
                placeholder.setContent(content);
            }
            element = ref;
        }
        if (element instanceof MContext && (context = ((MContext)element).getContext()) != null) {
            IEclipseContext newParentContext = this.modelService.getContainingContext(element);
            if (context.getParent() != newParentContext) {
                context.setParent(newParentContext);
            }
        }
        if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            ArrayList kids = new ArrayList(container.getChildren());
            for (MUIElement childElement : kids) {
                this.showElementRecursive(childElement);
            }
        }
    }
}

