/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.group.gms;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MemberNotInViewException;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.util.MessageReceiver;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.group.GroupService;

public class GroupServiceProvider
implements GroupService,
CallBack {
    private static final Logger logger = GMSLogDomain.getLogger((String)"ShoalLogger");
    private String myName;
    private String groupName;
    private Properties configProps = new Properties();
    private GroupManagementService gms;
    private GroupHandle groupHandle;
    private ConcurrentHashMap<String, String> aliveInstances = new ConcurrentHashMap();
    private List<GroupMemberEventListener> listeners = new ArrayList<GroupMemberEventListener>();
    private boolean createdAndJoinedGMSGroup;
    private AtomicLong previousViewId = new AtomicLong(-100L);
    private volatile AliveAndReadyView arView;
    private ConcurrentHashMap<String, Long> lastSendMsgFailNotification = new ConcurrentHashMap();

    public GroupServiceProvider(String myName, String groupName, boolean startGMS) {
        this.init(myName, groupName, startGMS);
    }

    public void processNotification(Signal notification) {
        boolean isJoin = true;
        if (notification instanceof JoinedAndReadyNotificationSignal || notification instanceof FailureNotificationSignal || notification instanceof PlannedShutdownSignal) {
            isJoin = notification instanceof JoinedAndReadyNotificationSignal;
            this.checkAndNotifyAboutCurrentAndPreviousMembers(notification.getMemberToken(), isJoin, true);
        }
    }

    private synchronized void checkAndNotifyAboutCurrentAndPreviousMembers(String memberName, boolean isJoinEvent, boolean triggeredByGMS) {
        SortedSet currentAliveAndReadyMembers = this.gms.getGroupHandle().getCurrentAliveAndReadyCoreView().getMembers();
        AliveAndReadyView aView = this.gms.getGroupHandle().getPreviousAliveAndReadyCoreView();
        TreeSet<String> previousAliveAndReadyMembers = new TreeSet();
        if (aView == null) {
            return;
        }
        long arViewId = aView.getViewId();
        long knownId = this.previousViewId.get();
        Signal sig = aView.getSignal();
        if (knownId < arViewId) {
            if (this.previousViewId.compareAndSet(knownId, arViewId)) {
                this.arView = aView;
                sig = this.arView.getSignal();
                previousAliveAndReadyMembers = this.arView.getMembers();
            } else {
                previousAliveAndReadyMembers = this.arView.getMembers();
            }
        } else {
            previousAliveAndReadyMembers = this.arView.getMembers();
        }
        for (GroupMemberEventListener listener : this.listeners) {
            listener.onViewChange(memberName, currentAliveAndReadyMembers, previousAliveAndReadyMembers, isJoinEvent);
        }
        if (triggeredByGMS) {
            StringBuilder sb = new StringBuilder("**VIEW: ");
            sb.append("prevViewId: " + knownId).append("; curViewID: ").append(arViewId).append("; signal: ").append(sig).append(" ");
            sb.append("[current: ");
            String delim = "";
            for (String member : currentAliveAndReadyMembers) {
                sb.append(delim).append(member);
                delim = ", ";
            }
            sb.append("]  [previous: ");
            delim = "";
            for (String member : previousAliveAndReadyMembers) {
                sb.append(delim).append(member);
                delim = ", ";
            }
            sb.append("]");
            logger.log(Level.INFO, sb.toString());
            logger.log(Level.INFO, "**********************************************************************");
        }
    }

    private void init(String myName, String groupName, boolean startGMS) {
        try {
            this.gms = GMSFactory.getGMSModule((String)groupName);
        }
        catch (Exception e) {
            logger.severe("GMS module for group " + groupName + " not enabled");
        }
        if (this.gms == null) {
            if (startGMS) {
                logger.info("GroupServiceProvider *CREATING* gms module for group " + groupName);
                GroupManagementService.MemberType memberType = myName.startsWith("monitor-") ? GroupManagementService.MemberType.SPECTATOR : GroupManagementService.MemberType.CORE;
                this.configProps.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), System.getProperty("MULTICASTADDRESS", "229.9.1.1"));
                this.configProps.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), (Object)2299);
                logger.info("Is initial host=" + System.getProperty("IS_INITIAL_HOST"));
                this.configProps.put(ServiceProviderConfigurationKeys.IS_BOOTSTRAPPING_NODE.toString(), System.getProperty("IS_INITIAL_HOST", "false"));
                if (System.getProperty("INITIAL_HOST_LIST") != null) {
                    this.configProps.put(ServiceProviderConfigurationKeys.VIRTUAL_MULTICAST_URI_LIST.toString(), (Object)myName.equals("DAS"));
                }
                this.configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), System.getProperty("MAX_MISSED_HEARTBEATS", "3"));
                this.configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TIMEOUT.toString(), System.getProperty("HEARTBEAT_FREQUENCY", "2000"));
                this.configProps.put(ServiceProviderConfigurationKeys.LOOPBACK.toString(), "true");
                String bindInterfaceAddress = System.getProperty("BIND_INTERFACE_ADDRESS");
                if (bindInterfaceAddress != null) {
                    this.configProps.put(ServiceProviderConfigurationKeys.BIND_INTERFACE_ADDRESS.toString(), bindInterfaceAddress);
                }
                this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)myName, (String)groupName, (GroupManagementService.MemberType)memberType, (Properties)this.configProps);
                this.createdAndJoinedGMSGroup = true;
            } else {
                logger.fine("**GroupServiceProvider:: Will not start GMS module for group " + groupName + ". It should have been started by now. But GMS: " + this.gms);
            }
        } else {
            logger.fine("**GroupServiceProvider:: GMS module for group " + groupName + " should have been started by now GMS: " + this.gms);
        }
        if (this.gms == null) {
            throw new IllegalStateException("GMS has not been started yet for group name: " + groupName + ". Is the cluster up and running");
        }
        this.groupHandle = this.gms.getGroupHandle();
        this.myName = myName;
        this.groupName = groupName;
        this.gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl((CallBack)this));
        this.gms.addActionFactory((JoinedAndReadyNotificationActionFactory)new JoinedAndReadyNotificationActionFactoryImpl((CallBack)this));
        this.gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl((CallBack)this));
        this.gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl((CallBack)this));
        logger.info("**GroupServiceProvider:: REGISTERED member event listeners for <group, instance> => <" + groupName + ", " + myName + ">");
        if (this.createdAndJoinedGMSGroup) {
            try {
                this.gms.join();
                Thread.sleep(3000L);
                this.gms.reportJoinedAndReadyState();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Got an exception during reportJoinedAndReadyState?", ex);
            }
        }
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        return this.groupHandle.getCurrentCoreMembers();
    }

    public void shutdown() {
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getMemberName() {
        return this.myName;
    }

    @Override
    public boolean sendMessage(String targetMemberName, String token, byte[] data) {
        try {
            this.groupHandle.sendMessage(targetMemberName, token, data);
            return true;
        }
        catch (MemberNotInViewException memEx) {
            String msg = "Error during groupHandle.sendMessage(" + targetMemberName + "," + token + ") failed because " + targetMemberName + " is not alive?";
            this.logSendMsgFailure((GMSException)((Object)memEx), targetMemberName, msg);
        }
        catch (GMSException gmsEx) {
            try {
                this.groupHandle.sendMessage(targetMemberName, token, data);
                return true;
            }
            catch (GMSException gmsEx2) {
                String msg = "Error during groupHandle.sendMessage(" + targetMemberName + ", " + token + "; size=" + (data == null ? -1 : data.length) + ")";
                this.logSendMsgFailure(gmsEx2, targetMemberName, msg);
            }
        }
        return false;
    }

    void logSendMsgFailure(GMSException t, String targetMemberName, String message) {
        long SEND_FAILED_NOTIFICATION_PERIOD = 43200000L;
        if (targetMemberName == null) {
            targetMemberName = "";
        }
        Long lastNotify = this.lastSendMsgFailNotification.get(targetMemberName);
        long currentTime = System.currentTimeMillis();
        if (lastNotify == null || currentTime > lastNotify + 43200000L) {
            this.lastSendMsgFailNotification.put(targetMemberName, new Long(currentTime));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, message, t);
            } else {
                Throwable causeT = t.getCause();
                String cause = causeT == null ? t.getMessage() : causeT.getMessage();
                logger.log(Level.WARNING, message + " Cause:" + cause);
            }
        }
    }

    @Override
    public void registerGroupMessageReceiver(String messageToken, MessageReceiver receiver) {
        logger.fine("[GroupServiceProvider]:  REGISTERED A MESSAGE LISTENER: " + receiver + "; for token: " + messageToken);
        this.gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl((CallBack)receiver), messageToken);
    }

    @Override
    public void registerGroupMemberEventListener(GroupMemberEventListener listener) {
        this.listeners.add(listener);
        this.checkAndNotifyAboutCurrentAndPreviousMembers(this.myName, true, false);
    }

    @Override
    public void removeGroupMemberEventListener(GroupMemberEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
        if (this.createdAndJoinedGMSGroup) {
            this.shutdown();
        }
    }
}

