/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.util;

import com.sun.enterprise.connectors.deployment.annotation.handlers.ConfigPropertyHandler;
import com.sun.enterprise.connectors.deployment.annotation.handlers.ConnectorAnnotationHandler;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.Connector;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ConnectorValidator
extends DefaultDOLVisitor
implements ConnectorVisitor {
    private Logger _logger = LogDomains.getLogger(ConnectorValidator.class, (String)"javax.enterprise.resource.resourceadapter");

    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof ConnectorDescriptor) {
            ConnectorDescriptor connectorDesc = (ConnectorDescriptor)descriptor;
            this.accept(connectorDesc);
        }
    }

    public void accept(ConnectorDescriptor descriptor) {
        Set connectionDefinitions;
        this.validateActivationSpec(descriptor);
        if (!descriptor.getValidConnectorAnnotationProcessed()) {
            Set annotations = descriptor.getConnectorAnnotations();
            String raClass = descriptor.getResourceAdapterClass();
            if (annotations.size() == 0) {
                return;
            }
            if (annotations.size() == 1) {
                Iterator it = annotations.iterator();
                AnnotationInfo annotationInfo = (AnnotationInfo)it.next();
                Class claz = (Class)annotationInfo.getAnnotatedElement();
                Connector connector = (Connector)annotationInfo.getAnnotation();
                ConnectorAnnotationHandler.processDescriptor(claz, connector, descriptor);
                Collection configProperties = descriptor.getConfigPropertyAnnotations(claz.getName());
                if (configProperties != null) {
                    for (AnnotationInfo ai : configProperties) {
                        ConfigPropertyHandler handler = new ConfigPropertyHandler();
                        try {
                            handler.processAnnotation(ai);
                        }
                        catch (AnnotationProcessorException e) {
                            RuntimeException re = new RuntimeException("Unable to process ConfigProperty annotation in class [" + claz.getName() + "] : " + e.getMessage());
                            re.initCause(e);
                            throw re;
                        }
                    }
                }
            } else if ((raClass == null || raClass.equals("")) && annotations.size() > 1) {
                throw new RuntimeException("cannot determine appropriate @Connector annotation as multiple annotations are present");
            }
        }
        if (descriptor.getOutBoundDefined() && (connectionDefinitions = descriptor.getOutboundResourceAdapter().getConnectionDefs()).size() == 0) {
            throw new RuntimeException("Invalid connector descriptor for RAR [ " + descriptor.getName() + " ], when outbound-resource-adapter is specified,atleast one connection-definition must be specified either via annotation or via descriptor");
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, descriptor.toString());
        }
        this.processConfigProperties(descriptor);
        descriptor.getConnectorAnnotations().clear();
        descriptor.getAllConfigPropertyAnnotations().clear();
        descriptor.getConfigPropertyProcessedClasses().clear();
    }

    private void validateActivationSpec(ConnectorDescriptor descriptor) {
        if (descriptor.getInBoundDefined()) {
            InboundResourceAdapter ira = descriptor.getInboundResourceAdapter();
            Set messageListeners = ira.getMessageListeners();
            for (MessageListener ml : messageListeners) {
                String activationSpecClass = ml.getActivationSpecClass();
                if (activationSpecClass != null && !activationSpecClass.equals("")) {
                    Class clazz = this.getClass(descriptor, activationSpecClass);
                    boolean validClass = false;
                    if (clazz != null && ActivationSpec.class.isAssignableFrom(clazz)) {
                        validClass = true;
                    }
                    if (validClass) continue;
                    throw new IllegalArgumentException("Class [" + activationSpecClass + "] does not implement javax.resource.spi.ActivationSpec interface, but defined in MessageListener [" + ml.getMessageListenerType() + "] of RAR [" + descriptor.getName() + "]");
                }
                throw new RuntimeException("ActivationSpec class cannot be null or empty for message-listener[" + ml.getMessageListenerType() + "] of RAR [" + descriptor.getName() + "]");
            }
        }
    }

    private void processConfigProperties(ConnectorDescriptor desc) {
        Class claz;
        String raClass = desc.getResourceAdapterClass();
        if (raClass != null && !raClass.equals("") && !desc.getConfigPropertyProcessedClasses().contains(raClass)) {
            Class claz2 = this.getClass(desc, raClass);
            ConfigPropertyHandler.processParent(claz2, desc.getConfigProperties());
        }
        if (desc.getOutBoundDefined()) {
            OutboundResourceAdapter ora = desc.getOutboundResourceAdapter();
            Set connectionDefs = ora.getConnectionDefs();
            for (ConnectionDefDescriptor connectionDef : connectionDefs) {
                String connectionFactoryClass = connectionDef.getConnectionFactoryIntf();
                if (connectionFactoryClass == null || connectionFactoryClass.equals("") || desc.getConfigPropertyProcessedClasses().contains(connectionFactoryClass)) continue;
                claz = this.getClass(desc, connectionDef.getManagedConnectionFactoryImpl());
                ConfigPropertyHandler.processParent(claz, connectionDef.getConfigProperties());
            }
        }
        if (desc.getInBoundDefined()) {
            InboundResourceAdapter ira = desc.getInboundResourceAdapter();
            Set messageListeners = ira.getMessageListeners();
            for (MessageListener ml : messageListeners) {
                String activationSpecClass = ml.getActivationSpecClass();
                if (activationSpecClass == null || activationSpecClass.equals("") || desc.getConfigPropertyProcessedClasses().contains(activationSpecClass)) continue;
                claz = this.getClass(desc, activationSpecClass);
                ConfigPropertyHandler.processParent(claz, ml.getConfigProperties());
            }
        }
        Set adminObjects = desc.getAdminObjects();
        for (AdminObject ao : adminObjects) {
            String uniqueName = ao.getAdminObjectInterface() + "_" + ao.getAdminObjectClass();
            if (desc.getConfigPropertyProcessedClasses().contains(uniqueName)) continue;
            Class claz3 = this.getClass(desc, ao.getAdminObjectClass());
            ConfigPropertyHandler.processParent(claz3, ao.getConfigProperties());
        }
    }

    private Class getClass(ConnectorDescriptor desc, String className) {
        Class<?> claz = null;
        try {
            claz = desc.getClassLoader() != null ? desc.getClassLoader().loadClass(className) : Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this._logger.log(Level.WARNING, "Unable to load class [ " + className + " ]", e.getMessage());
            throw new RuntimeException("Unable to load class [ " + className + " ]");
        }
        return claz;
    }
}

