/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.lang.annotation.ElementType;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.xml.ContainerElementTypeConfigurationBuilder;
import org.hibernate.validator.internal.xml.GroupConversionBuilder;
import org.hibernate.validator.internal.xml.MetaConstraintBuilder;
import org.hibernate.validator.internal.xml.binding.ConstraintType;
import org.hibernate.validator.internal.xml.binding.ParameterType;

class ConstrainedParameterBuilder {
    private final GroupConversionBuilder groupConversionBuilder;
    private final MetaConstraintBuilder metaConstraintBuilder;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;

    ConstrainedParameterBuilder(MetaConstraintBuilder metaConstraintBuilder, GroupConversionBuilder groupConversionBuilder, AnnotationProcessingOptionsImpl annotationProcessingOptions) {
        this.metaConstraintBuilder = metaConstraintBuilder;
        this.groupConversionBuilder = groupConversionBuilder;
        this.annotationProcessingOptions = annotationProcessingOptions;
    }

    List<ConstrainedParameter> buildConstrainedParameters(List<ParameterType> parameterList, Executable executable, String defaultPackage) {
        ArrayList<ConstrainedParameter> constrainedParameters = CollectionHelper.newArrayList();
        int i = 0;
        for (ParameterType parameterType : parameterList) {
            ConstraintLocation constraintLocation = ConstraintLocation.forParameter(executable, i);
            Type type = ReflectionHelper.typeOf(executable, i);
            HashSet metaConstraints = new HashSet();
            for (ConstraintType constraint : parameterType.getConstraint()) {
                MetaConstraint metaConstraint = this.metaConstraintBuilder.buildMetaConstraint(constraintLocation, constraint, ElementType.PARAMETER, defaultPackage, null);
                metaConstraints.add(metaConstraint);
            }
            ContainerElementTypeConfigurationBuilder containerElementTypeConfigurationBuilder = new ContainerElementTypeConfigurationBuilder(this.metaConstraintBuilder, this.groupConversionBuilder, constraintLocation, defaultPackage);
            ContainerElementTypeConfigurationBuilder.ContainerElementTypeConfiguration containerElementTypeConfiguration = containerElementTypeConfigurationBuilder.build(parameterType.getContainerElementType(), type);
            if (parameterType.getIgnoreAnnotations() != null) {
                this.annotationProcessingOptions.ignoreConstraintAnnotationsOnParameter(executable, i, parameterType.getIgnoreAnnotations());
            }
            ConstrainedParameter constrainedParameter = new ConstrainedParameter(ConfigurationSource.XML, executable, type, i, metaConstraints, containerElementTypeConfiguration.getMetaConstraints(), this.getCascadingMetaDataForParameter(containerElementTypeConfiguration.getTypeParametersCascadingMetaData(), type, parameterType, defaultPackage));
            constrainedParameters.add(constrainedParameter);
            ++i;
        }
        return constrainedParameters;
    }

    private CascadingMetaDataBuilder getCascadingMetaDataForParameter(Map<TypeVariable<?>, CascadingMetaDataBuilder> containerElementTypesCascadingMetaData, Type type, ParameterType parameterType, String defaultPackage) {
        boolean isCascaded = parameterType.getValid() != null;
        Map<Class<?>, Class<?>> groupConversions = this.groupConversionBuilder.buildGroupConversionMap(parameterType.getConvertGroup(), defaultPackage);
        return CascadingMetaDataBuilder.annotatedObject(type, isCascaded, containerElementTypesCascadingMetaData, groupConversions);
    }
}

