/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.ee.resources;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.osgi.ee.resources.BaseResourceManager;
import org.glassfish.osgi.ee.resources.Habitat;
import org.glassfish.osgi.ee.resources.Invalidate;
import org.glassfish.osgi.ee.resources.ResourceManager;
import org.osgi.framework.BundleContext;

public class JMSResourceManager
extends BaseResourceManager
implements ResourceManager {
    public JMSResourceManager(Habitat habitat) {
        super(habitat);
    }

    @Override
    public void registerResources(BundleContext context) {
        this.registerJmsResources(context);
    }

    public void registerJmsResources(BundleContext context) {
        Collection connectorResources = this.getResources().getResources(ConnectorResource.class);
        for (ConnectorResource resource : connectorResources) {
            if (!this.isJmsResource(resource)) continue;
            ResourceRef resRef = this.getResourceHelper().getResourceRef(resource.getJndiName());
            this.registerResource((BindableResource)resource, resRef, context);
        }
    }

    @Override
    public void registerResource(BindableResource resource, ResourceRef resRef, BundleContext bundleContext) {
        ConnectorResource connectorResource = (ConnectorResource)resource;
        if (connectorResource.getEnabled().equalsIgnoreCase("true") && resRef != null && resRef.getEnabled().equalsIgnoreCase("true")) {
            String poolName = connectorResource.getPoolName();
            ConnectorConnectionPool pool = (ConnectorConnectionPool)this.getResources().getResourceByName(ConnectorConnectionPool.class, poolName);
            String defnName = pool.getConnectionDefinitionName();
            Class<QueueConnectionFactory> claz = null;
            Class[] intf = null;
            if (defnName.equals("javax.jms.QueueConnectionFactory")) {
                claz = QueueConnectionFactory.class;
                intf = new Class[]{QueueConnectionFactory.class, Invalidate.class};
            } else if (defnName.equals("javax.jms.TopicConnectionFactory")) {
                claz = TopicConnectionFactory.class;
                intf = new Class[]{TopicConnectionFactory.class, Invalidate.class};
            } else if (defnName.equals("javax.jms.ConnectionFactory")) {
                claz = ConnectionFactory.class;
                intf = new Class[]{ConnectionFactory.class, Invalidate.class};
            } else {
                throw new RuntimeException("Invalid connection-definition [ " + defnName + " ]" + " for jms-resource [ " + resource.getJndiName() + " ]");
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("jndi-name", connectorResource.getJndiName());
            Object o = this.getProxy(connectorResource.getJndiName(), intf, this.getClassLoader());
            this.registerResourceAsService(bundleContext, (BindableResource)connectorResource, claz.getName(), properties, o);
        }
    }

    @Override
    public boolean handlesResource(BindableResource resource) {
        boolean result = false;
        if (resource instanceof ConnectorResource) {
            result = this.isJmsResource((ConnectorResource)resource);
        }
        return result;
    }

    private boolean isJmsResource(ConnectorResource resource) {
        boolean result = false;
        String poolName = resource.getPoolName();
        ConnectorConnectionPool pool = (ConnectorConnectionPool)this.getResources().getResourceByName(ConnectorConnectionPool.class, poolName);
        String raName = pool.getResourceAdapterName();
        if (raName.equals("jmsra")) {
            result = true;
        }
        return result;
    }
}

