/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.integration;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class PermsHolder {
    private ConcurrentHashMap<String, PermissionCollection> loaderPC = new ConcurrentHashMap();
    private PermissionCollection eePermissionCollection = null;
    private PermissionCollection declaredPermissionCollection = null;
    private PermissionCollection restrictPermissionCollection = null;

    public PermsHolder() {
    }

    public PermsHolder(PermissionCollection eePC, PermissionCollection declPC, PermissionCollection restrictPC) {
        this.setEEPermissions(eePC);
        this.setDeclaredPermissions(declPC);
        this.setRestrictPermissions(restrictPC);
    }

    public void setEEPermissions(PermissionCollection eePc) {
        this.eePermissionCollection = eePc;
    }

    public void setDeclaredPermissions(PermissionCollection declaredPc) {
        this.declaredPermissionCollection = declaredPc;
    }

    public void setRestrictPermissions(PermissionCollection restrictPC) {
        this.restrictPermissionCollection = restrictPC;
    }

    public PermissionCollection getCachedPerms(CodeSource codesource) {
        if (codesource == null) {
            return null;
        }
        String codeUrl = codesource.getLocation().toString();
        return this.loaderPC.get(codeUrl);
    }

    public PermissionCollection getPermissions(CodeSource codesource, PermissionCollection parentPC) {
        PermissionCollection tmpPc;
        Permission p;
        String codeUrl = codesource.getLocation().toString();
        PermissionCollection cachedPermissons = this.loaderPC.get(codeUrl);
        if (cachedPermissons != null) {
            return cachedPermissons;
        }
        cachedPermissons = new Permissions();
        PermissionCollection pc = parentPC;
        if (pc != null) {
            Enumeration<Permission> perms = pc.elements();
            while (perms.hasMoreElements()) {
                p = perms.nextElement();
                cachedPermissons.add(p);
            }
        }
        if (this.declaredPermissionCollection != null) {
            Enumeration<Permission> dperms = this.declaredPermissionCollection.elements();
            while (dperms.hasMoreElements()) {
                p = dperms.nextElement();
                cachedPermissons.add(p);
            }
        }
        if (this.eePermissionCollection != null) {
            Enumeration<Permission> eeperms = this.eePermissionCollection.elements();
            while (eeperms.hasMoreElements()) {
                p = eeperms.nextElement();
                cachedPermissons.add(p);
            }
        }
        if ((tmpPc = this.loaderPC.putIfAbsent(codeUrl, cachedPermissons)) != null) {
            cachedPermissons = tmpPc;
        }
        return cachedPermissons;
    }
}

