/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.node.AdministeredObjectDefinitionNode;
import com.sun.enterprise.deployment.node.ConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.JMSConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.JMSDestinationDefinitionNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MailSessionNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.node.AroundInvokeNode;
import org.glassfish.ejb.deployment.node.AroundTimeoutNode;
import org.glassfish.ejb.deployment.node.EjbNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbInterceptorNode
extends DeploymentDescriptorNode<EjbInterceptor> {
    private EjbInterceptor descriptor;

    public EjbInterceptorNode() {
        this.registerElementHandler(new XMLElement("around-invoke"), AroundInvokeNode.class, "addAroundInvokeDescriptor");
        this.registerElementHandler(new XMLElement("around-timeout"), AroundTimeoutNode.class, "addAroundTimeoutDescriptor");
        this.registerElementHandler(new XMLElement("post-activate"), LifecycleCallbackNode.class, "addPostActivateDescriptor");
        this.registerElementHandler(new XMLElement("pre-passivate"), LifecycleCallbackNode.class, "addPrePassivateDescriptor");
        this.registerElementHandler(new XMLElement("around-construct"), LifecycleCallbackNode.class, "addAroundConstructDescriptor");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("mail-session"), MailSessionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("connection-factory"), ConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("administered-object"), AdministeredObjectDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-connection-factory"), JMSConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-destination"), JMSDestinationDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class, "addEnvironmentProperty");
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        JndiEnvRefNode serviceRefNode = (JndiEnvRefNode)this.habitat.getService(JndiEnvRefNode.class, "service-ref", new Annotation[0]);
        if (serviceRefNode != null) {
            this.registerElementHandler(new XMLElement("service-ref"), serviceRefNode.getClass(), "addServiceReferenceDescriptor");
        }
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addResourceEnvReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class);
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("interceptor-class", "setInterceptorClassName");
        return table;
    }

    public EjbInterceptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new EjbInterceptor();
            this.descriptor.setEjbBundleDescriptor((EjbBundleDescriptor)this.getParentNode().getDescriptor());
        }
        return this.descriptor;
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Adding ejb ref " + newDescriptor);
            }
            this.getDescriptor().addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else if (newDescriptor instanceof MessageDestinationReferenceDescriptor) {
            MessageDestinationReferenceDescriptor msgDestRef = (MessageDestinationReferenceDescriptor)newDescriptor;
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)this.getParentNode().getDescriptor();
            msgDestRef.setReferringBundleDescriptor((BundleDescriptor)ejbBundle);
            this.getDescriptor().addMessageDestinationReferenceDescriptor(msgDestRef);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbInterceptor descriptor) {
        Element interceptorNode = EjbInterceptorNode.appendChild((Node)parent, (String)nodeName);
        this.writeLocalizedDescriptions(interceptorNode, (Descriptor)descriptor);
        EjbInterceptorNode.appendTextChild((Node)interceptorNode, (String)"interceptor-class", (String)descriptor.getInterceptorClassName());
        if (descriptor.hasAroundInvokeDescriptor()) {
            EjbNode.writeAroundInvokeDescriptors(interceptorNode, descriptor.getAroundInvokeDescriptors().iterator());
        }
        if (descriptor.hasAroundTimeoutDescriptor()) {
            EjbNode.writeAroundTimeoutDescriptors(interceptorNode, descriptor.getAroundTimeoutDescriptors().iterator());
        }
        if (descriptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT)) {
            this.writeLifeCycleCallbackDescriptors(interceptorNode, "around-construct", descriptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT));
        }
        if (descriptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT)) {
            this.writeLifeCycleCallbackDescriptors(interceptorNode, "post-construct", descriptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT));
        }
        if (descriptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY)) {
            this.writeLifeCycleCallbackDescriptors(interceptorNode, "pre-destroy", descriptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY));
        }
        if (descriptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE)) {
            this.writeLifeCycleCallbackDescriptors(interceptorNode, "post-activate", descriptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE));
        }
        if (descriptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE)) {
            this.writeLifeCycleCallbackDescriptors(interceptorNode, "pre-passivate", descriptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE));
        }
        this.writeResourceDescriptors(interceptorNode, descriptor.getAllResourcesDescriptors().iterator());
        return interceptorNode;
    }
}

