/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import com.sun.jsftemplating.util.fileStreamer.ServletStreamerContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletStreamer
extends HttpServlet {
    public static final String SERVLET_STREAMER_CONTEXT = "servletStreamerContext";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String sources = config.getInitParameter("ContentSources");
        if (sources != null && sources.trim().length() != 0) {
            FileStreamer fs = FileStreamer.getFileStreamer(config.getServletContext());
            StringTokenizer tokens = new StringTokenizer(sources, " \t\n\r\f,;:");
            while (tokens.hasMoreTokens()) {
                fs.registerContentSource(tokens.nextToken());
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block4: {
            ServletStreamerContext context = this.getServletStreamerContext(request, response);
            try {
                FileStreamer.getFileStreamer(this.getServletContext()).streamContent(context);
            }
            catch (FileNotFoundException ex) {
                if (LogUtil.infoEnabled()) {
                    LogUtil.info("JSFT0004", request.getPathInfo());
                }
                response.sendError(404);
            }
            catch (IOException ex) {
                if (!LogUtil.infoEnabled()) break block4;
                String path = request.getPathInfo();
                LogUtil.info("JSFT0004", path);
                if (!LogUtil.fineEnabled()) break block4;
                LogUtil.fine("Resource (" + path + ") not available!", ex);
            }
        }
    }

    protected ServletStreamerContext getServletStreamerContext(HttpServletRequest request, HttpServletResponse response) {
        ServletStreamerContext ctx = (ServletStreamerContext)request.getAttribute(SERVLET_STREAMER_CONTEXT);
        if (ctx == null) {
            ctx = new ServletStreamerContext(request, response, this.getServletConfig());
            request.setAttribute(SERVLET_STREAMER_CONTEXT, (Object)ctx);
        }
        ctx.setServletResponse(response);
        return ctx;
    }

    protected long getLastModified(HttpServletRequest request) {
        ServletStreamerContext context = this.getServletStreamerContext(request, null);
        ContentSource source = context.getContentSource();
        return source.getLastModified(context);
    }
}

