/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.enterprise.transaction.jts.JavaEETransactionManagerJTSDelegate;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.RegisteredStatics;
import com.sun.jts.CosTransactions.StaticResource;
import com.sun.jts.CosTransactions.TransactionFactoryImpl;
import com.sun.jts.codegen.otsidl.JControlHelper;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.StatusHolder;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.otid_t;

public class CurrentTransaction {
    private static Hashtable threadContexts = new Hashtable(100);
    private static Vector suspended = new Vector(10000);
    static boolean statsOn = false;
    private static Hashtable importedTransactions = new Hashtable();
    private static RegisteredStatics statics = null;
    private static ThreadLocal m_tid = new ThreadLocal();
    static Logger _logger = LogDomains.getLogger(CurrentTransaction.class, (String)"javax.enterprise.system.core.transaction");
    private static PropagationContext emptyContext = new PropagationContext(0, new TransIdentity(null, null, new otid_t(-1, 0, new byte[0])), new TransIdentity[0], null);

    static void initialise() {
    }

    static boolean setCurrent(ControlImpl control, boolean stack) {
        boolean result = false;
        ControlImpl current = (ControlImpl)m_tid.get();
        if (current != null) {
            if (stack) {
                Thread thread;
                if (statics != null) {
                    statics.distributeEnd(current, false);
                }
                StatusHolder outStatus = new StatusHolder();
                control.pushControl(current, outStatus);
                result = statsOn ? threadContexts.remove(thread = Thread.currentThread()) != null : true;
                m_tid.set(null);
                if (statsOn) {
                    suspended.addElement(current);
                }
            }
        } else {
            result = true;
        }
        if (result) {
            if (statics != null) {
                statics.distributeStart(control, stack);
            }
            if (statsOn) {
                Thread thread = Thread.currentThread();
                threadContexts.put(thread, control);
            }
            m_tid.set(control);
            if (statsOn) {
                suspended.removeElement(control);
            }
            control.incrementAssociation();
        }
        return result;
    }

    static ControlImpl endCurrent(boolean unstack) {
        ControlImpl result = (ControlImpl)m_tid.get();
        if (result != null) {
            StatusHolder outStatus;
            ControlImpl stacked;
            if (statsOn) {
                Thread thread = Thread.currentThread();
                threadContexts.remove(thread);
            }
            m_tid.set(null);
            result.decrementAssociation();
            if (!unstack && statsOn) {
                suspended.addElement(result);
            }
            if (statics != null) {
                statics.distributeEnd(result, unstack);
            }
            if (unstack && (stacked = result.popControl(outStatus = new StatusHolder())) != null && outStatus.value == Status.StatusActive) {
                if (statics != null) {
                    statics.distributeStart(stacked, false);
                }
                if (statsOn) {
                    Thread thread = Thread.currentThread();
                    threadContexts.put(thread, stacked);
                    suspended.removeElement(stacked);
                }
                m_tid.set(stacked);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static boolean isTxAssociated() {
        return m_tid.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ControlImpl endAborted(boolean[] aborted, boolean endAssociation) {
        boolean completed = true;
        aborted[0] = false;
        ControlImpl result = (ControlImpl)m_tid.get();
        if (result != null) {
            try {
                completed = result.getTranState() != Status.StatusActive;
            }
            catch (Throwable exc) {
                _logger.log(Level.FINE, "", exc);
            }
        }
        if (result != null && completed) {
            if (endAssociation) {
                Thread thread;
                Class<CurrentTransaction> exc = CurrentTransaction.class;
                // MONITORENTER : com.sun.jts.CosTransactions.CurrentTransaction.class
                if (statsOn) {
                    thread = Thread.currentThread();
                    threadContexts.remove(thread);
                }
                m_tid.set(null);
                if (statics != null) {
                    statics.distributeEnd(result, false);
                }
                if ((result = result.popAborted()) != null) {
                    m_tid.set(result);
                    if (statsOn) {
                        thread = Thread.currentThread();
                        threadContexts.put(thread, result);
                        suspended.removeElement(result);
                    }
                }
                if (statics != null) {
                    statics.distributeStart(result, false);
                }
                // MONITOREXIT : exc
            }
            aborted[0] = true;
        }
        if (!_logger.isLoggable(Level.FINEST)) return result;
        Thread thread = Thread.currentThread();
        _logger.logp(Level.FINEST, "CurrentTransaction", "endAborted()", "threadContexts.get(thread) returned " + result + " for current thread " + thread);
        return result;
    }

    static void addSuspended(ControlImpl control) {
        if (statsOn) {
            suspended.addElement(control);
        }
    }

    static boolean removeSuspended(ControlImpl control) {
        boolean result = true;
        if (statsOn) {
            result = suspended.removeElement(control);
        }
        return result;
    }

    public static ControlImpl getCurrent() throws TRANSACTION_ROLLEDBACK {
        ControlImpl result = (ControlImpl)m_tid.get();
        return result;
    }

    static Coordinator getCurrentCoordinator() throws TRANSACTION_ROLLEDBACK, Unavailable {
        ControlImpl control = (ControlImpl)m_tid.get();
        Coordinator result = null;
        if (control != null) {
            result = Configuration.isLocalFactory() ? control.get_localCoordinator() : control.get_coordinator();
        }
        return result;
    }

    static int numActive(Long localTID, boolean[] outstanding) {
        if (!statsOn) {
            throw new NO_IMPLEMENT("statistics not on");
        }
        int result = 0;
        outstanding[0] = false;
        StatusHolder outStatus = new StatusHolder();
        Enumeration controls = threadContexts.elements();
        while (controls.hasMoreElements()) {
            ControlImpl current = (ControlImpl)controls.nextElement();
            outStatus.value = Status.StatusRolledBack;
            try {
                Long currentLocalTID = current.getLocalTID(outStatus);
                if (outStatus.value != Status.StatusActive || !currentLocalTID.equals(localTID)) continue;
                outstanding[0] = outstanding[0] | current.isOutgoing();
                ++result;
            }
            catch (Throwable exc) {
                _logger.log(Level.FINE, "", exc);
            }
        }
        return result;
    }

    static synchronized void registerStatic(StaticResource obj) {
        if (statics == null) {
            statics = new RegisteredStatics();
        }
        statics.addStatic(obj);
    }

    static Control[] getSuspendedTransactions() {
        int suspNum;
        if (!statsOn) {
            throw new NO_IMPLEMENT("statistics not on");
        }
        Control[] result = null;
        int n = suspNum = suspended != null ? suspended.size() : 0;
        if (suspNum > 0) {
            result = new Control[suspNum];
            Enumeration controls = suspended.elements();
            int pos = 0;
            while (controls.hasMoreElements()) {
                result[pos++] = ((ControlImpl)controls.nextElement()).object();
            }
        } else {
            result = new Control[]{};
        }
        return result;
    }

    static Control[] getRunningTransactions() {
        int runNum;
        if (!statsOn) {
            throw new NO_IMPLEMENT("statistics not on");
        }
        Control[] result = null;
        int n = runNum = threadContexts != null ? threadContexts.size() : 0;
        if (runNum > 0) {
            result = new Control[runNum];
            Enumeration controls = threadContexts.elements();
            int pos = 0;
            while (controls.hasMoreElements()) {
                result[pos++] = ((ControlImpl)controls.nextElement()).object();
            }
        } else {
            result = new Control[]{};
        }
        return result;
    }

    static Control[] getAllTransactions() {
        int allNum;
        if (!statsOn) {
            throw new NO_IMPLEMENT("statistics not on");
        }
        Control[] result = null;
        int n = allNum = threadContexts != null ? threadContexts.size() + suspended.size() : 0;
        if (allNum > 0) {
            result = new Control[allNum];
            Enumeration<java.lang.Object> controls = suspended.elements();
            int pos = 0;
            while (controls.hasMoreElements()) {
                result[pos++] = ((ControlImpl)controls.nextElement()).object();
            }
            controls = threadContexts.elements();
            while (controls.hasMoreElements()) {
                result[pos++] = ((ControlImpl)controls.nextElement()).object();
            }
        } else {
            result = new Control[]{};
        }
        return result;
    }

    static void sendingRequest(int id, PropagationContextHolder holder) throws TRANSACTION_ROLLEDBACK, TRANSACTION_REQUIRED {
        boolean[] outBoolean = new boolean[1];
        ControlImpl current = CurrentTransaction.endAborted(outBoolean, false);
        if (outBoolean[0]) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (current == null) {
            return;
        }
        try {
            holder.value = current.getTXContext();
        }
        catch (Unavailable exc) {
            INVALID_TRANSACTION ex2 = new INVALID_TRANSACTION(0, CompletionStatus.COMPLETED_NO);
            ex2.initCause((Throwable)exc);
            throw ex2;
        }
        catch (TRANSACTION_ROLLEDBACK exc) {
            CurrentTransaction.endCurrent(true);
            current.destroy();
            throw (TRANSACTION_ROLLEDBACK)exc.fillInStackTrace();
        }
        catch (Throwable exc) {
            _logger.log(Level.FINE, "", exc);
        }
    }

    static void receivedReply(int id, PropagationContext context, Environment ex) throws WrongTransaction {
        ControlImpl current = (ControlImpl)m_tid.get();
        if (current == null) {
            return;
        }
        Exception ctxExc = ex.exception();
        if (ctxExc instanceof SystemException) {
            Coordinator currentCoord = null;
            try {
                currentCoord = Configuration.isLocalFactory() ? current.get_localCoordinator() : current.get_coordinator();
            }
            catch (Unavailable exc) {
                _logger.log(Level.FINE, "", exc);
            }
            if (currentCoord == null) {
                return;
            }
            try {
                currentCoord.rollback_only();
            }
            catch (Inactive exc) {
                _logger.log(Level.FINE, "", exc);
            }
        }
        if (context == null || context.current == null || context.current.coord == null || context.current.otid.formatID == -1) {
            return;
        }
        StatusHolder outStatus = new StatusHolder();
        outStatus.value = Status.StatusRolledBack;
        GlobalTID globalTID = null;
        try {
            globalTID = new GlobalTID(current.getGlobalTID(outStatus));
        }
        catch (Throwable exc) {
            _logger.log(Level.FINE, "", exc);
        }
        if (globalTID != null) {
            if (outStatus.value != Status.StatusActive) {
                CurrentTransaction.endCurrent(true);
                current.destroy();
                WrongTransaction exc = new WrongTransaction();
                throw exc;
            }
            if (!globalTID.isSameTID(context.current.otid)) {
                WrongTransaction exc = new WrongTransaction();
                throw exc;
            }
        }
    }

    static void receivedRequest(int id, PropagationContext context) {
        if (context == null || context.current == null || context.current.otid.formatID == -1) {
            return;
        }
        JavaEETransactionManagerJTSDelegate.getInstance().initXA();
        Control current = Configuration.getFactory().recreate(context);
        importedTransactions.put(Thread.currentThread(), new GlobalTID(context.current.otid));
        try {
            ControlImpl contImpl = null;
            contImpl = Configuration.isLocalFactory() ? (ControlImpl)current : ControlImpl.servant(JControlHelper.narrow((Object)current));
            CurrentTransaction.setCurrent(contImpl, false);
        }
        catch (Throwable exc) {
            _logger.log(Level.WARNING, "jts.unable_to_create_subordinate_coordinator", exc);
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_create_subordinate_coordinator");
            throw new INTERNAL(msg);
        }
    }

    static void sendingReply(int id, PropagationContextHolder holder) throws INVALID_TRANSACTION, TRANSACTION_ROLLEDBACK {
        GlobalTID importedTID;
        block21: {
            if (CurrentTransaction.emptyContext.implementation_specific_data == null) {
                ORB orb = Configuration.getORB();
                CurrentTransaction.emptyContext.implementation_specific_data = orb.create_any();
                CurrentTransaction.emptyContext.implementation_specific_data.insert_boolean(false);
            }
            boolean[] outBoolean = new boolean[1];
            ControlImpl current = CurrentTransaction.endAborted(outBoolean, true);
            if (outBoolean[0]) {
                importedTransactions.remove(Thread.currentThread());
                TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
                throw exc;
            }
            Thread thread = Thread.currentThread();
            importedTID = (GlobalTID)importedTransactions.remove(thread);
            if (importedTID == null && current == null) {
                return;
            }
            StatusHolder outStatus = new StatusHolder();
            try {
                if (importedTID == null || current == null || !importedTID.isSameTID(current.getGlobalTID(outStatus)) || outStatus.value != Status.StatusActive) {
                    INVALID_TRANSACTION exc = new INVALID_TRANSACTION(6, CompletionStatus.COMPLETED_YES);
                    throw exc;
                }
            }
            catch (SystemException ex) {
                _logger.log(Level.FINE, "", ex);
                INVALID_TRANSACTION exc = new INVALID_TRANSACTION(6, CompletionStatus.COMPLETED_YES);
                throw exc;
            }
            CoordinatorImpl coord = null;
            Coordinator coordRef = null;
            try {
                if (Configuration.isLocalFactory()) {
                    coord = (CoordinatorImpl)current.get_localCoordinator();
                } else {
                    coordRef = current.get_coordinator();
                    coord = CoordinatorImpl.servant(coordRef);
                }
                CoordinatorImpl forgetParent = null;
                int[] outInt = new int[1];
                try {
                    forgetParent = coord.replyAction(outInt);
                }
                catch (Throwable exc) {
                    _logger.log(Level.FINE, "", exc);
                }
                int replyAction = outInt[0];
                if (replyAction == 3) {
                    try {
                        coord.rollback_only();
                    }
                    catch (Throwable ex) {
                        _logger.log(Level.FINE, "", ex);
                    }
                    INVALID_TRANSACTION exc = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_YES);
                    throw exc;
                }
                CurrentTransaction.endCurrent(false);
                if (replyAction == 2) {
                    current.destroy();
                    coord.cleanUpEmpty(forgetParent);
                    break block21;
                }
                if (current.isAssociated() || current.isOutgoing()) {
                    try {
                        coord.rollback_only();
                    }
                    catch (Throwable exc) {
                        _logger.log(Level.FINE, "", exc);
                    }
                    INVALID_TRANSACTION exc = new INVALID_TRANSACTION(2, CompletionStatus.COMPLETED_YES);
                    throw exc;
                }
                current.destroy();
            }
            catch (INVALID_TRANSACTION exc) {
                throw exc;
            }
            catch (Unavailable exc) {
                _logger.log(Level.FINE, "", exc);
            }
            catch (SystemException exc) {
                _logger.log(Level.FINE, "", exc);
            }
        }
        holder.value = new PropagationContext(0, new TransIdentity(null, null, importedTID.realTID), new TransIdentity[0], CurrentTransaction.emptyContext.implementation_specific_data);
    }

    public static void recreate(GlobalTID tid, int timeout) {
        if (!RecoveryManager.readAndUpdateTxMap(tid)) {
            throw new INVALID_TRANSACTION(267, CompletionStatus.COMPLETED_NO);
        }
        try {
            TransactionFactoryImpl factory = (TransactionFactoryImpl)Configuration.getFactory();
            Control current = factory.recreate(tid, timeout);
            importedTransactions.put(Thread.currentThread(), tid);
            ControlImpl contImpl = null;
            contImpl = Configuration.isLocalFactory() ? (ControlImpl)current : ControlImpl.servant(JControlHelper.narrow((Object)current));
            CurrentTransaction.setCurrent(contImpl, false);
        }
        catch (Throwable exc) {
            RecoveryManager.removeFromTxMap(tid);
            _logger.log(Level.WARNING, "jts.unable_to_create_subordinate_coordinator", exc);
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.unable_to_create_subordinate_coordinator");
            throw new INVALID_TRANSACTION(msg, 266, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static void release(GlobalTID tid) {
        Thread thread = RecoveryManager.getThreadFromTxMap(tid);
        if (thread == null || thread != Thread.currentThread()) {
            return;
        }
        RecoveryManager.removeFromTxMap(tid);
        boolean[] outBoolean = new boolean[1];
        ControlImpl control = CurrentTransaction.endAborted(outBoolean, true);
        if (outBoolean[0]) {
            importedTransactions.remove(Thread.currentThread());
            return;
        }
        GlobalTID importedTID = (GlobalTID)importedTransactions.remove(thread);
        StatusHolder outStatus = new StatusHolder();
        try {
            if (importedTID == null || control == null || !importedTID.isSameTID(control.getGlobalTID(outStatus)) || outStatus.value != Status.StatusActive) {
                INVALID_TRANSACTION exc = new INVALID_TRANSACTION(6, CompletionStatus.COMPLETED_YES);
                throw exc;
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.FINE, "", ex);
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(6, CompletionStatus.COMPLETED_YES);
            throw exc;
        }
        CurrentTransaction.endCurrent(false);
        control.destroy();
    }

    static synchronized void endAll(GlobalTID globalTID, boolean aborted) {
        throw new NO_IMPLEMENT("not implemented");
    }

    static void shutdown(boolean immediate) {
    }

    static void dump() {
    }
}

