/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.transaction;

import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.transaction.TransactionException;
import com.sun.xml.ws.rx.rm.runtime.transaction.TransactionHandler;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class TransactionHandlerImpl
implements TransactionHandler {
    private static final Logger LOGGER = Logger.getLogger(TransactionHandlerImpl.class);
    private UserTransaction userTransaction = null;

    @Override
    public void begin(int txTimeout) throws TransactionException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.setTransactionTimeout(txTimeout);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Transaction timeout set to " + txTimeout);
            }
        }
        catch (SystemException se) {
            String message = "Not able to set transaction timeout on UserTransaction.";
            LOGGER.severe(message, (Throwable)se);
            throw new TransactionException(message, se);
        }
        try {
            userTransaction.begin();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("UserTransaction started.");
            }
        }
        catch (Throwable t) {
            String message = "Not able to begin UserTransaction.";
            LOGGER.severe(message, t);
            throw new TransactionException(message, t);
        }
    }

    @Override
    public void commit() throws TransactionException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.commit();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("UserTransaction committed successfully.");
            }
        }
        catch (Throwable t) {
            String message = "Not able to commit UserTransaction.";
            LOGGER.severe(message, t);
            throw new TransactionException(message, t);
        }
    }

    @Override
    public void rollback() throws TransactionException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.rollback();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("UserTransaction rolled back successfully.");
            }
        }
        catch (Throwable t) {
            String message = "Not able to roll back UserTransaction.";
            LOGGER.severe(message, t);
            throw new TransactionException(message, t);
        }
    }

    @Override
    public void setRollbackOnly() throws TransactionException {
        UserTransaction userTransaction = this.getUserTransaction();
        try {
            userTransaction.setRollbackOnly();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("UserTransaction marked for roll back successfully.");
            }
        }
        catch (Throwable t) {
            String message = "Not able to mark UserTransaction for roll back.";
            LOGGER.severe(message, t);
            throw new TransactionException(message, t);
        }
    }

    @Override
    public boolean userTransactionAvailable() throws TransactionException {
        UserTransaction ut = this.getUserTransaction();
        return ut != null;
    }

    @Override
    public boolean isActive() throws TransactionException {
        int status = this.getStatus();
        return status == 0;
    }

    @Override
    public boolean isMarkedForRollback() throws TransactionException {
        int status = this.getStatus();
        return status == 1;
    }

    @Override
    public boolean canBegin() {
        boolean txExists = this.transactionExists();
        return !txExists;
    }

    @Override
    public boolean transactionExists() throws TransactionException {
        int status = this.getStatus();
        boolean noTX = 6 == status || 3 == status || 4 == status;
        return !noTX;
    }

    @Override
    public int getStatus() throws TransactionException {
        UserTransaction ut = this.getUserTransaction();
        int status = 6;
        try {
            status = ut.getStatus();
        }
        catch (SystemException se) {
            String message = "Not able to get UserTransaction status.";
            LOGGER.severe(message, (Throwable)se);
            throw new TransactionException(message, se);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("UserTransaction status is: " + status);
        }
        return status;
    }

    @Override
    public String getStatusAsString() throws TransactionException {
        int status = this.getStatus();
        String statusString = null;
        switch (status) {
            case 0: {
                statusString = "STATUS_ACTIVE";
                break;
            }
            case 1: {
                statusString = "STATUS_MARKED_ROLLBACK";
                break;
            }
            case 2: {
                statusString = "STATUS_PREPARED";
                break;
            }
            case 3: {
                statusString = "STATUS_COMMITTED";
                break;
            }
            case 4: {
                statusString = "STATUS_ROLLEDBACK";
                break;
            }
            case 5: {
                statusString = "STATUS_UNKNOWN";
                break;
            }
            case 6: {
                statusString = "STATUS_NO_TRANSACTION";
                break;
            }
            case 7: {
                statusString = "STATUS_PREPARING";
                break;
            }
            case 8: {
                statusString = "STATUS_COMMITTING";
                break;
            }
            case 9: {
                statusString = "STATUS_ROLLING_BACK";
                break;
            }
            default: {
                statusString = "INVALID VALUE";
            }
        }
        return statusString;
    }

    @Nullable
    private UserTransaction getUserTransaction() {
        block3: {
            if (this.userTransaction != null) {
                return this.userTransaction;
            }
            try {
                InitialContext initialContext = new InitialContext();
                this.userTransaction = (UserTransaction)initialContext.lookup("java:comp/UserTransaction");
            }
            catch (NamingException ne) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                String message = "NamingException while looking up UserTransaction from InitialContext. Which is expected off server.";
                LOGGER.fine(message, (Throwable)ne);
            }
        }
        return this.userTransaction;
    }
}

