/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.frames.HeaderBlockHead;
import org.glassfish.grizzly.http2.hpack.Decoder;
import org.glassfish.grizzly.http2.hpack.DecodingCallback;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class HeadersDecoder {
    private final Decoder hpackDecoder;
    private final MemoryManager memoryManager;
    private final int maxHeaderSize;
    private int currentHeaderSize;
    private HeaderBlockHead firstHeaderFrame;
    private Buffer inBuffer;

    public HeadersDecoder(MemoryManager memoryManager, int maxHeaderSize, int maxHeaderTableSize) {
        this.memoryManager = memoryManager;
        this.maxHeaderSize = maxHeaderSize;
        this.hpackDecoder = new Decoder(maxHeaderTableSize);
    }

    public boolean append(Buffer buffer) {
        this.currentHeaderSize += buffer.remaining();
        if (this.currentHeaderSize <= this.maxHeaderSize) {
            this.inBuffer = Buffers.appendBuffers(this.memoryManager, this.inBuffer, buffer, true);
            return true;
        }
        return false;
    }

    public void decode(DecodingCallback callback) {
        if (this.inBuffer != null) {
            this.hpackDecoder.decode(this.inBuffer, !this.isProcessingHeaders(), callback);
            this.inBuffer.tryDispose();
            this.inBuffer = null;
        }
    }

    public HeaderBlockHead finishHeader() {
        HeaderBlockHead firstHeaderFrameLocal = this.firstHeaderFrame;
        this.firstHeaderFrame = null;
        this.currentHeaderSize = 0;
        return firstHeaderFrameLocal;
    }

    public void setFirstHeaderFrame(HeaderBlockHead firstHeaderFrame) {
        this.firstHeaderFrame = firstHeaderFrame;
    }

    public boolean isProcessingHeaders() {
        return this.firstHeaderFrame != null;
    }
}

