/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.multianno;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.Util;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class MAManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
Referenceable {
    private Reference reference;
    private ResourceAdapter resourceAdapter;
    private int count;
    private String password;
    private String user;
    private String userName;

    public String getUser() {
        return this.user;
    }

    public void setUser(String val) {
        this.user = val;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String val) {
        this.userName = val;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String val) {
        this.password = val;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MAManagedConnectionFactory.createConnectionFactory", "cxManager", "TSEISDataSource");
        return new TSEISDataSource((ManagedConnectionFactory)this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MAManagedConnectionFactory.createConnectionFactory", "", "TSEISDataSource");
        return new TSEISDataSource((ManagedConnectionFactory)this, null);
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        ++this.count;
        String newStr1 = new String("MAManagedConnectionFactory setResourceAdapter " + this.count);
        this.debug(newStr1);
        this.resourceAdapter = ra;
    }

    public ResourceAdapter getResourceAdapter() {
        this.debug("MAManagedConnectionFactory.getResource");
        return this.resourceAdapter;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            ConnectorStatus.getConnectorStatus().logAPI("MAManagedConnectionFactory.createManagedConnection", "subject|info", "TSManagedConnection");
            TSConnection con = null;
            PasswordCredential pc = Util.getPasswordCredential((ManagedConnectionFactory)this, (Subject)subject, (ConnectionRequestInfo)info);
            if (pc == null) {
                this.debug("MAManagedConnectionFactory.createManagedConnection():  pc == null");
                this.debug("TSConnectionImpl.getConnection()");
                con = new TSConnectionImpl().getConnection();
            } else {
                this.debug("MAManagedConnectionFactory.createManagedConnection():  pc != null");
                this.setUser(pc.getUserName());
                this.setUserName(pc.getUserName());
                this.setPassword(new String(pc.getPassword()));
                this.debug("TSConnectionImpl.getConnection(u,p)");
                con = new TSConnectionImpl().getConnection(pc.getUserName(), pc.getPassword());
            }
            return new TSManagedConnection((ManagedConnectionFactory)this, pc, null, con, false, true);
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("Exception: " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MAManagedConnectionFactory.matchManagedConnection", "connectionSet|subject|info", "TSEISDataSource");
        PasswordCredential pc = Util.getPasswordCredential((ManagedConnectionFactory)this, (Subject)subject, (ConnectionRequestInfo)info);
        for (Object obj : connectionSet) {
            if (!(obj instanceof TSManagedConnection)) continue;
            TSManagedConnection mc = (TSManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual((PasswordCredential)mc.getPasswordCredential(), (PasswordCredential)pc) || mcf == null || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MAManagedConnectionFactory)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MAManagedConnectionFactory that = (MAManagedConnectionFactory)obj;
        if (this.reference != null && !this.reference.equals(that.getReference())) {
            return false;
        }
        if (this.reference == null && that.getReference() != null) {
            return false;
        }
        if (this.resourceAdapter != null && !this.resourceAdapter.equals(that.getResourceAdapter())) {
            return false;
        }
        if (this.resourceAdapter == null && that.getResourceAdapter() != null) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (!Util.isEqual((String)this.password, (String)that.getPassword())) {
            return false;
        }
        if (!Util.isEqual((String)this.user, (String)that.getUser())) {
            return false;
        }
        return Util.isEqual((String)this.userName, (String)that.getUserName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Reference getReference() {
        Reference ref = this.reference;
        return ref;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int val) {
        this.count = val;
    }

    private void debug(String str) {
        Debug.trace((String)str);
    }
}

