/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusEventComplete;
import org.glassfish.api.admin.progress.ProgressStatusEventCreateChild;
import org.glassfish.api.admin.progress.ProgressStatusEventProgress;
import org.glassfish.api.admin.progress.ProgressStatusEventSet;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class ProgressStatusEventJsonProvider
extends BaseProvider<ProgressStatusEvent> {
    private static final JsonFactory factory = new JsonFactory();

    public ProgressStatusEventJsonProvider() {
        super(ProgressStatusEvent.class, MediaType.APPLICATION_JSON_TYPE, new MediaType("application", "x-javascript"));
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    @Override
    public void writeTo(ProgressStatusEvent proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator out = factory.createJsonGenerator(entityStream, JsonEncoding.UTF8);
        out.writeStartObject();
        this.writePSEvent(proxy, out);
        out.writeEndObject();
        out.flush();
    }

    private void writePSEvent(ProgressStatusEvent event, JsonGenerator out) throws IOException {
        if (event == null) {
            return;
        }
        out.writeObjectFieldStart("progress-status-event");
        out.writeStringField("id", event.getSourceId());
        if (event instanceof ProgressStatusEventProgress) {
            this.writePSEventProgress((ProgressStatusEventProgress)event, out);
        } else if (event instanceof ProgressStatusEventSet) {
            this.writePSEventSet((ProgressStatusEventSet)event, out);
        } else if (event instanceof ProgressStatusEventComplete) {
            this.writePSEventComplete((ProgressStatusEventComplete)event, out);
        } else if (event instanceof ProgressStatusEventCreateChild) {
            this.writePSEventCreateChild((ProgressStatusEventCreateChild)event, out);
        } else {
            out.writeEndObject();
        }
    }

    private void writePSEventSet(ProgressStatusEventSet event, JsonGenerator out) throws IOException {
        out.writeObjectFieldStart("set");
        if (event.getTotalStepCount() != null) {
            out.writeNumberField("total-step-count", event.getTotalStepCount().intValue());
        }
        if (event.getCurrentStepCount() != null) {
            out.writeNumberField("current-step-count", event.getCurrentStepCount().intValue());
        }
        out.writeEndObject();
    }

    private void writePSEventProgress(ProgressStatusEventProgress event, JsonGenerator out) throws IOException {
        out.writeObjectFieldStart("progres");
        out.writeNumberField("steps", event.getSteps());
        if (StringUtils.ok((String)event.getMessage())) {
            out.writeStringField("message", event.getMessage());
        }
        if (event.isSpinner()) {
            out.writeBooleanField("spinner", event.isSpinner());
        }
        out.writeEndObject();
    }

    private void writePSEventComplete(ProgressStatusEventComplete event, JsonGenerator out) throws IOException {
        out.writeObjectFieldStart("complete");
        if (StringUtils.ok((String)event.getMessage())) {
            out.writeStringField("message", event.getMessage());
        }
        out.writeEndObject();
    }

    private void writePSEventCreateChild(ProgressStatusEventCreateChild event, JsonGenerator out) throws IOException {
        out.writeObjectFieldStart("create-child");
        out.writeStringField("id", event.getChildId());
        out.writeNumberField("allocated-steps", event.getAllocatedSteps());
        out.writeNumberField("total-step-count", event.getTotalSteps());
        if (StringUtils.ok((String)event.getName())) {
            out.writeStringField("name", event.getName());
        }
        out.writeEndObject();
    }

    @Override
    public String getContent(ProgressStatusEvent proxy) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

