/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.ibanno;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.WorkImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkListenerImpl;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import com.sun.ts.tests.common.connector.whitebox.ibanno.IBAnnoMessageListener;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.Xid;

public class IBAnnoWorkManager {
    private BootstrapContext bsc = null;
    private WorkManager wmgr;
    private Xid myxid;
    private Xid mynestxid;

    public IBAnnoWorkManager(BootstrapContext val) {
        this.debug("enterred constructor");
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.debug("leaving constructor");
    }

    public void runTests() {
        this.debug("enterred runTests");
        this.doWork();
        this.doTCWork();
        this.debug("leaving runTests");
    }

    public void doWork() {
        this.debug("enterred doWork");
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            WorkListenerImpl wl = new WorkListenerImpl();
            this.wmgr.doWork((Work)workimpl, 5000L, ec, (WorkListener)wl);
            ConnectorStatus.getConnectorStatus().logState("IBAnnoWorkManager Work Object Submitted");
            this.debug("IBAnnoWorkManager Work Object Submitted");
        }
        catch (WorkException we) {
            System.out.println("IBAnnoWorkManager WorkException thrown is " + we.getMessage());
        }
        catch (Exception ex) {
            System.out.println("IBAnnoWorkManager Exception thrown is " + ex.getMessage());
        }
        this.debug("leaving doWork");
    }

    private TransactionContext startTx() {
        TransactionContext tc = new TransactionContext();
        try {
            XidImpl xid = new XidImpl();
            tc.setXid((Xid)xid);
            tc.setTransactionTimeout(5000L);
        }
        catch (Exception ex) {
            Debug.printDebugStack((Exception)ex);
        }
        return tc;
    }

    public void doTCWork() {
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            TransactionContext tc = this.startTx();
            Debug.trace((String)"Creating IBAnnoMessageListener");
            XidImpl myid = new XidImpl();
            IBAnnoMessageListener wl = new IBAnnoMessageListener(myid, this.bsc);
            this.wmgr.doWork((Work)workimpl, 5000L, (ExecutionContext)tc, (WorkListener)wl);
            ConnectorStatus.getConnectorStatus().logState("TransactionContext Work Object Submitted");
        }
        catch (WorkException we) {
            Debug.trace((String)("TestWorkManager Exception thrown is " + we.getMessage()));
        }
    }

    public void setXid(Xid xid) {
        this.myxid = xid;
    }

    public Xid getXid() {
        return this.myxid;
    }

    public void setNestXid(Xid xid) {
        this.mynestxid = xid;
    }

    public Xid getNestXid() {
        return this.mynestxid;
    }

    public void debug(String out) {
        Debug.trace((String)("IBAnnoWorkManager:  " + out));
    }
}

