package ONVIF::Media::Types::CertificateGenerationParameters;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %CertificateID_of :ATTR(:get<CertificateID>);
my %Subject_of :ATTR(:get<Subject>);
my %ValidNotBefore_of :ATTR(:get<ValidNotBefore>);
my %ValidNotAfter_of :ATTR(:get<ValidNotAfter>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        CertificateID
        Subject
        ValidNotBefore
        ValidNotAfter
        Extension

    ) ],
    {
        'CertificateID' => \%CertificateID_of,
        'Subject' => \%Subject_of,
        'ValidNotBefore' => \%ValidNotBefore_of,
        'ValidNotAfter' => \%ValidNotAfter_of,
        'Extension' => \%Extension_of,
    },
    {
        'CertificateID' => 'SOAP::WSDL::XSD::Typelib::Builtin::token',
        'Subject' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'ValidNotBefore' => 'SOAP::WSDL::XSD::Typelib::Builtin::token',
        'ValidNotAfter' => 'SOAP::WSDL::XSD::Typelib::Builtin::token',
        'Extension' => 'ONVIF::Media::Types::CertificateGenerationParametersExtension',
    },
    {

        'CertificateID' => 'CertificateID',
        'Subject' => 'Subject',
        'ValidNotBefore' => 'ValidNotBefore',
        'ValidNotAfter' => 'ValidNotAfter',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Media::Types::CertificateGenerationParameters

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CertificateGenerationParameters from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * CertificateID


=item * Subject


=item * ValidNotBefore


=item * ValidNotAfter


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::CertificateGenerationParameters
   CertificateID =>  $some_value, # token
   Subject =>  $some_value, # string
   ValidNotBefore =>  $some_value, # token
   ValidNotAfter =>  $some_value, # token
   Extension =>  { # ONVIF::Media::Types::CertificateGenerationParametersExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

