
package ONVIF::Device::Elements::GetDeviceInformationResponse;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('GetDeviceInformationResponse');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Manufacturer_of :ATTR(:get<Manufacturer>);
my %Model_of :ATTR(:get<Model>);
my %FirmwareVersion_of :ATTR(:get<FirmwareVersion>);
my %SerialNumber_of :ATTR(:get<SerialNumber>);
my %HardwareId_of :ATTR(:get<HardwareId>);

__PACKAGE__->_factory(
    [ qw(        Manufacturer
        Model
        FirmwareVersion
        SerialNumber
        HardwareId

    ) ],
    {
        'Manufacturer' => \%Manufacturer_of,
        'Model' => \%Model_of,
        'FirmwareVersion' => \%FirmwareVersion_of,
        'SerialNumber' => \%SerialNumber_of,
        'HardwareId' => \%HardwareId_of,
    },
    {
        'Manufacturer' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Model' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'FirmwareVersion' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'SerialNumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'HardwareId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'Manufacturer' => 'Manufacturer',
        'Model' => 'Model',
        'FirmwareVersion' => 'FirmwareVersion',
        'SerialNumber' => 'SerialNumber',
        'HardwareId' => 'HardwareId',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::GetDeviceInformationResponse

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
GetDeviceInformationResponse from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Manufacturer

 $element->set_Manufacturer($data);
 $element->get_Manufacturer();




=item * Model

 $element->set_Model($data);
 $element->get_Model();




=item * FirmwareVersion

 $element->set_FirmwareVersion($data);
 $element->get_FirmwareVersion();




=item * SerialNumber

 $element->set_SerialNumber($data);
 $element->get_SerialNumber();




=item * HardwareId

 $element->set_HardwareId($data);
 $element->get_HardwareId();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::GetDeviceInformationResponse->new($data);

Constructor. The following data structure may be passed to new():

 {
   Manufacturer =>  $some_value, # string
   Model =>  $some_value, # string
   FirmwareVersion =>  $some_value, # string
   SerialNumber =>  $some_value, # string
   HardwareId =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

