/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "hoverwidget.h"

#include <QPainter>
#include <QStyleOption>

#include <QDebug>
#define THEME_QT_SCHEMA                  "org.ukui.style"
#define MODE_QT_KEY                      "style-name"

HoverWidget::HoverWidget(QString mname, QWidget *parent) :
    QWidget(parent),
    _name(mname)
{
    setAttribute(Qt::WA_DeleteOnClose);
}

HoverWidget::~HoverWidget()
{
}

void HoverWidget::enterEvent(QEvent *event){
    emit enterWidget(_name);

    QWidget::enterEvent(event);
}

void HoverWidget::leaveEvent(QEvent *event){
    emit leaveWidget(_name);

    QWidget::leaveEvent(event);
}

//子类化一个QWidget，为了能够使用样式表，则需要提供paintEvent事件。
//这是因为QWidget的paintEvent()是空的，而样式表要通过paint被绘制到窗口中。
void HoverWidget::paintEvent(QPaintEvent *event){
    Q_UNUSED(event)
    QStyleOption opt;
    opt.init(this);
    QPainter p(this);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);
}

void HoverWidget::mousePressEvent(QMouseEvent *event) {
    emit widgetClicked(_name);
}
