/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef NOTICEINTERFACE_H
#define NOTICEINTERFACE_H

#include <QObject>
#include <QDBusArgument>
#include <QVariant>
#include <QDBusMetaType>
#include <QGSettings>

struct NoticeApp
{
    QString desktop;
    QString name;
    QString icon;
    bool status;
    bool voice;
    bool detail;
    bool show;
    int mode;
};
const QDBusArgument &operator<<(QDBusArgument &argument, const NoticeApp &app);
const QDBusArgument &operator>>(const QDBusArgument &argument, NoticeApp &app);
Q_DECLARE_METATYPE(NoticeApp)


class NoticeInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Notice")
    Q_PROPERTY(bool isAutostartDisturb READ getAutostartDisturb)
    Q_PROPERTY(bool isProjectionScreenDisturb READ getProjectionsScreenDisturb)
    Q_PROPERTY(bool isFullScreenDisturb READ getFullScreenDisturb)
    Q_PROPERTY(bool isAlarmClockDisturb READ getAlarmClockDisturb)
    Q_PROPERTY(QString timeStart READ getTimeStart)
    Q_PROPERTY(QString timeEnd READ getTimeEnd)
    Q_PROPERTY(bool isEnable READ getNoticeEnable)
    Q_PROPERTY(QList <QVariant> noticeAppList READ getNoticeAppList)
//    Q_PROPERTY(int cursorSpeed READ getCursorSpeed)
public:
    NoticeInterface();

protected:
    bool getAutostartDisturb();
    bool getProjectionsScreenDisturb();
    bool getFullScreenDisturb();
    bool getAlarmClockDisturb();
    QString getTimeStart();
    QString getTimeEnd();

    bool getNoticeEnable();
    QList <QVariant> getNoticeAppList();

private:
    void getAppInfo(NoticeApp &app,const QString &desktop);

public Q_SLOTS:
    void setNoticeDisturb(const QString &key, bool value);
    void setNoticeDisturb(const QString &key, const QString &value);
    void setUkccNotice(const QString &key, bool value);
    void setAppInfo(const QString &desktop, const QString &key, bool value);
    void setAppInfo(const QString &desktop, const QString &key, const QString &value);

private:
    QGSettings *mUkccNoticeGsettings = nullptr;
    QGSettings *mUkuiNoticeGsettings = nullptr;
    QGSettings *mStyleGsettings = nullptr;

    QMap <QString, QString> mGsettingMap;
    QMap <QString, QGSettings *> mNoticeAppsMap;

    QStringList mWhiteList;
    QStringList mApplist;

Q_SIGNALS:
    void changed(const QString &key);
};

#endif // NOTICEINTERFACE_H
