/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef DEFAULTINTERFACE_H
#define DEFAULTINTERFACE_H
#include <QObject>
#include <QVariant>
#include <QVector>
#include <KSycoca>
#include <KApplicationTrader>
#include <KSharedConfig>
#include <KConfigGroup>
#include <QDBusArgument>
#include <QDBusMetaType>

struct Service
{
    QString icon;
    QString name;
    QString storageId;
};

const QDBusArgument &operator<<(QDBusArgument &argument, const Service &service);
const QDBusArgument &operator>>(const QDBusArgument &argument, Service &service);
Q_DECLARE_METATYPE(Service)

class DefaultInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Default")
    Q_PROPERTY(QMap <QString , QVariant> sysDefaultList READ getSystemDefaultAppList)
public:
    DefaultInterface();

private:
    QString mLocalMimefile = NULL;
    static QMap <QString , QVariant> mSysDefaultList;
    QStringList mBrowserMimeTypeList;
    QStringList mMailMimeTypeList;
    QStringList mTextMimeTypeList;

protected:
    QMap <QString , QVariant> getSystemDefaultAppList();

public Q_SLOTS:
    QVariantList getDefaultApp(const QString &mimeType);
    QVariantList getAppList(const QString &mimeType);
    void setDefaultApp(const QString &storageId, const QString &mimeType);
    void saveMimeTypeAssociation(const QString &mime, const QString &storageId);

};

#endif // DEFAULTINTERFACE_H
