/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef GLOBALTHEME_P_H
#define GLOBALTHEME_P_H

#include <QObject>
#include <QMap>
#include <QPixmap>

class QSettings;

class GlobalThemePrivate
{
public:
    GlobalThemePrivate() {}

    QString themeName;
    QString localeThemeName;

    bool supportLightDarkMode = true;
    QString defaultLightDarkMode = "light";

    QString widgetStyleName = "default";
    QString qtLightThemeName = "ukui-light";
    QString qtDarkThemeName = "ukui-dark";
    QString qtMixedThemeName = "ukui-default";
    QString qtAccentRole = "daybreakBlue";

    QString gtkThemeName = "ukui-white";
    QString gtkLightThemeName = "ukui-white";
    QString gtkDarkThemeName = "ukui-black";
    QString gtkAccent = "#3790FA";

    QString iconThemeName = "ukui-icon-theme-default";
    QString cursorThemeName = "DMZ-white";
    QString wallPaperPath = "/usr/share/backgrounds/ubuntukylin-default-settings.jpg";

    QString soundThemeName;

    bool supportBlur = true;
    bool blurEnabled = true;

    bool supportTransparency = true;
    int transparencyBlur = 50;
    int transparencyNoBlur = 90;

    bool supportAnimation = true;
    int animationDuration = 150;

    bool supportRadius = true;
    int  radiusValue = 12;

    QPixmap thumbnail;

    QString realPath;
    QSettings *settings = nullptr;
};

#endif // GLOBALTHEME_P_H
