/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef BOOT_H
#define BOOT_H

#include <QObject>
#include <QDBusInterface>
#include <QDBusReply>
#include <QDBusUnixFileDescriptor>
#include <unistd.h>

#include "shell/interface.h"
#include "grubverifydialog.h"
#include "bootui.h"

class Boot : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    Boot();
    ~Boot() Q_DECL_OVERRIDE;

    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget *pluginUi() Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

private:
    BootUi  *bootWidget   =nullptr;
    int      pluginType   = 0;
    QString  pluginName   = "";
    bool     mFirstLoad   = true;

    QDBusInterface          *bootDbus = nullptr;
    QDBusUnixFileDescriptor m_inhibitFileDescriptor;

private:
    void initConnection();
    void initBootStatus();
    bool inhibit(QString what, QString who, QString why, QString mode);
    void uninhibit();
    void setGrubPasswd(QString pwd, bool isOpen);

private Q_SLOTS:
    void bootSlot(bool checked);
    void resetPasswdSlot();
};
#endif // BOOT_H
